package it.eng.rdlab.soa3.connector.service.jaxrs;


import it.eng.rdlab.soa3.connector.service.core.AuthenticationInternalService;
import it.eng.rdlab.soa3.connector.service.core.AuthenticationServiceFactory;

import java.util.HashMap;
import java.util.Map;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.sun.jersey.api.client.ClientResponse.Status;
import com.sun.jersey.api.core.HttpContext;

/**
 * REST service for the complete access control flow of SOA3 
 * @author Ciro Formisano
 * 
 */

@Path("/access")
public class AccessService 
{
	private Log logger;
	private final String AUTHORIZATION_HEADER = "Authorization";
	
	public AccessService()
	{
		this.logger = LogFactory.getLog(this.getClass());
	}

	private String [] parseHeader (String authHeader)
	{
		String [] encodedHeader = authHeader.split(" ");
		
		if (encodedHeader.length <2) 
		{
			logger.error("invalid authorization header "+authHeader);
			throw new WebApplicationException (Response.status(Status.BAD_REQUEST).entity("Invalid authorization header "+authHeader).build());
		}
		else return encodedHeader;
		
	}
	
	
	/**
	 * 
	 * Access control method
	 * 
	 * @param context
	 * @return
	 */
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	public String getAccessControl(@Context HttpContext context) 
	{
		logger.debug("Checking access privileges");
		String authHeader = context.getRequest().getHeaderValue(AUTHORIZATION_HEADER);
		
		if (authHeader != null)
		{
			logger.debug("Parsing authN header");
			String [] encodedHeader = parseHeader(authHeader);
			logger.debug("Parsing authN header");
			logger.debug("Authentication type "+encodedHeader [0]);
			Map<String, String> authenticationServiceRequestParameters = new HashMap<String, String> ();
			authenticationServiceRequestParameters.put(AuthenticationServiceFactory.REQUEST_HEADER, encodedHeader [0]);
			AuthenticationInternalService authenticationService = AuthenticationServiceFactory.generateService(authenticationServiceRequestParameters);
			
			if (authenticationService == null)
			{
				logger.error("invalid authorization header "+encodedHeader [0]);
				throw new WebApplicationException (Response.status(Status.BAD_REQUEST).entity("Invalid authorization header "+encodedHeader [0]).build());
	
			}
			else
			{
				logger.debug("Calling the authentication service");
				String ticket = authenticationService.authenticate(encodedHeader [1]);
				
				if (ticket != null)
				{
					logger.debug("Authentication OK, ticket "+ticket);
					return ticket;
				}
				else
				{
					logger.error("authentication unsuccessful");
					throw new WebApplicationException(Response.status(Status.UNAUTHORIZED).entity("Wrong credentials, check username and password ").build());
				}
			}
		}
		else
		{
			logger.error("Invalid authentication header");
			throw new WebApplicationException (Response.status(Status.BAD_REQUEST).entity("No authorization header found ").build());
			
		}


	}


}
