package it.eng.rdlab.soa3.connector.service.core.impl;

import it.eng.rdlab.soa3.connector.service.configuration.Configuration;
import it.eng.rdlab.soa3.connector.service.core.AccessControlManager;
import it.eng.rdlab.soa3.connector.service.core.AuthenticationInternalService;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * Session based authentication
 * 
 * @author Ciro Formisano (ENG)
 *
 */
public class SessionAuthenticationService extends AuthenticationInternalServiceImpl implements AuthenticationInternalService 
{
	private Log log;

	public SessionAuthenticationService() 
	{
		super ();
		this.log = LogFactory.getLog(this.getClass());
	}
	
	/*
	 * (non-Javadoc)
	 * @see it.eng.rdlab.soa3.connector.service.core.impl.AuthenticationInternalServiceImpl#askToSOA3(java.lang.String, long)
	 */
	@Override
	protected String askToSOA3(String id, long currentTime) 
	{
		log.debug("entry not found, SOA3 won't be called");
		log.debug("Authentication failed: inserting new value in the black list");
		AccessControlManager.getInstance().setAccessDeniedEntry(id, currentTime+Configuration.getInstance().getAuthValidity());
		log.debug("Black list updated");
		return null;
	}

}
