package it.eng.rdlab.soa3.connector.service.core.impl;

import it.eng.rdlab.soa3.connector.service.beans.AccessControlBean;
import it.eng.rdlab.soa3.connector.service.core.AccessControlManager;
import it.eng.rdlab.soa3.connector.service.core.AuthenticationInternalService;

import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;


/**
 * 
 * Abstract implementation of the authentication internal service
 * 
 * @author Ciro Formisano (ENG)
 *
 */
public abstract class AuthenticationInternalServiceImpl implements AuthenticationInternalService
{
	private Log log;
	
	public AuthenticationInternalServiceImpl ()
	{
		this.log = LogFactory.getLog(this.getClass());
	}
	
	/**
	 * {@inheritDoc} 
	 */
	@Override
	public String authenticate(String id) 
	{
		log.debug("Initialization");
		long currentTime = new Date().getTime();
		AccessControlBean responseBean = AccessControlManager.getInstance().getAccessControlBean(id);
		log.debug("Checking the cache");
		String ticket = null;
		
		if (responseBean != null)
		{
			if (!checkLocalCache(id, responseBean, currentTime))
			{
				log.debug("Invalid authentication parameter found");
				ticket = null;
			}
			else ticket = id;
		}
		
		if (ticket ==null && !isInBlackList(id, currentTime)) ticket = askToSOA3(id,currentTime);
		
		log.debug("ticket = "+ticket);
		return ticket;

	}
	
	private boolean checkLocalCache (String id,AccessControlBean accessControlBean,long currentTime)
	{
		log.debug("Username = "+accessControlBean.getUsername());
		long sessionEnd = accessControlBean.getSessionEnd();
		log.debug("Session end "+sessionEnd);
		boolean response = false;
		
		if (currentTime > sessionEnd) 
		{
			log.debug("Login expired");
			AccessControlManager.getInstance().removeAccessControlBean(id);
		}
		else
		{
			log.debug("Entry found in the cache");
			response = true;
		}
		
		return response;
	}
	
	private boolean isInBlackList (String id, long currentTime)
	{
		long blackListTime = AccessControlManager.getInstance().getAccessDeniedEntry(id);
		
		if (blackListTime > -1 && currentTime <= blackListTime) 
		{
			log.debug("Access attempt in the blacklist");
			return true;
		}
		else if (blackListTime != -1) AccessControlManager.getInstance().removeAccessDeniedEntry(id);
		
		return false;
	}
	
	/**
	 * 
	 * Sends the request to SOA3
	 * 
	 * @param id
	 * @param currentTime
	 * @return
	 */
	protected abstract String askToSOA3 (String id, long currentTime);
	
}
