package it.eng.rdlab.soa3.connector.service.core;

import it.eng.rdlab.soa3.connector.service.beans.AccessControlBean;

import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

/**
 * 
 * Access control manager singleton
 * 
 * @author Ciro Formisano (ENG)
 *
 */
public class AccessControlManager 
{
	private Map<String, AccessControlBean> accessControlMap;
	private static AccessControlManager instance;
	private Map<String, Long> accessDeniedMap; 
	
	private AccessControlManager ()
	{
		this.accessControlMap = Collections.synchronizedMap(new WeakHashMap<String, AccessControlBean>()); 
		this.accessDeniedMap = Collections.synchronizedMap(new WeakHashMap<String, Long>()); 
	}
	
	public static AccessControlManager getInstance ()
	{
		if (instance == null) instance = new AccessControlManager();
		
		return instance;
	}
	
	public synchronized AccessControlBean getAccessControlBean (String id)
	{
		return this.accessControlMap.get(id);
		
	}
	
	public synchronized void removeAccessControlBean (String id)
	{
		this.accessControlMap.remove(id);
		
	}
	
	public synchronized void setAccessControlBean (String id, AccessControlBean bean)
	{
		this.accessControlMap.put(id, bean);
	}
	
	
	public synchronized long getAccessDeniedEntry (String id)
	{
		Long accessDeniedExpiration =  this.accessDeniedMap.get(id);
		
		if (accessDeniedExpiration == null ) accessDeniedExpiration = -1l;
		
		return accessDeniedExpiration;
		
	}
	
	public synchronized void removeAccessDeniedEntry (String id)
	{
		this.accessDeniedMap.remove(id);
		
	}
	
	public synchronized void setAccessDeniedEntry (String id, long accessDeniedExpiration)
	{
		this.accessDeniedMap.put(id, accessDeniedExpiration);
	}
	
}
