package it.eng.rdlab.soa3.connector.service.configuration;

import it.eng.rdlab.soa3.connector.utils.SecurityManager;

import java.io.FileInputStream;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * 
 * Configuration manager singleton class
 * 
 * @author Ciro Formisano (ENG)
 *
 */
public class Configuration 
{
	private final long DEFAULT_AUTH_VALIDITY = 5; //min
	private final String DEFAULT_SOA3_URL = "http://localhost:8080";
	private static Configuration instance;
	private Properties properties = null;
	private Log logger = null;
	
	private Configuration ()
	{
		logger = LogFactory.getLog(this.getClass());
		properties = new Properties();

		String configurationFile = System.getProperty(ConfigurationConstants.CATALINA_HOME)+ConfigurationConstants.CONFIGURATION_PATH;
		logger.debug("Configuration file "+configurationFile);
		
		try
		{
			properties.load(new FileInputStream(configurationFile));
			
		} catch (Exception e)
		{
			logger.error("Unable to load configuration file: using default values",e);
		}
		
	}
	
	
	
	public static Configuration getInstance ()
	{
		if (instance == null) instance = new Configuration();
		
		return instance;
	}
	
	/**
	 * 
	 * Session validity
	 * 
	 * @return
	 */
	public long getAuthValidity ()
	{
		return getLongProperty(ConfigurationLabels.AUTH_SESSION, DEFAULT_AUTH_VALIDITY)*60000;
	}

	/**
	 * 
	 * Soa3 endopoint
	 * 
	 * @return
	 */
	public String getSoa3Endpoint ()
	{
		return this.properties.getProperty(ConfigurationLabels.SOA3_ENDPOINT,DEFAULT_SOA3_URL);
	}
	
	private long getLongProperty (String key, long defaultValue)
	{
		long result = -1;
		
		try {
		
			String stringValue = this.properties.getProperty(key);
			
			if (stringValue == null) result = defaultValue;
			else Long.parseLong(stringValue);
		
		} catch (Exception e)
		{
			logger.error("Invalid value, using default");
			result = defaultValue;
		}
		
		return result;

	}
	
	
	public String getCertFile ()
	{
		return this.properties.getProperty(ConfigurationLabels.CERT_FILE, SecurityManager.DEFAULT_CERT_FILE);
		
	}
	
	public String getKeyFile ()
	{
		return this.properties.getProperty(ConfigurationLabels.KEY_FILE, SecurityManager.DEFAULT_KEY_FILE);
		
	}
	
	public String getTrustDir ()
	{
		return this.properties.getProperty(ConfigurationLabels.TRUST_DIR, SecurityManager.DEFAULT_TRUST_DIR);
		
	}
	
	public String getTrustExt ()
	{
		return this.properties.getProperty(ConfigurationLabels.TRUST_FILE_EXTENSION, SecurityManager.DEFAULT_TRUST_FILE_EXTENSION);
		
	}
	
	
}
