package it.eng.rdlab.soa3.connector.service.core.impl;

import it.eng.rdlab.soa3.connector.beans.UserBean;
import it.eng.rdlab.soa3.connector.service.beans.AccessControlBean;
import it.eng.rdlab.soa3.connector.service.configuration.Configuration;
import it.eng.rdlab.soa3.connector.service.core.AccessControlManager;
import it.eng.rdlab.soa3.connector.service.core.AuthenticationInternalService;

import java.util.UUID;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.soa3.connector.Authenticate;
import org.gcube.soa3.connector.impl.UsernamePasswordAuthentication;

/**
 * 
 * Username/password based authentication
 * 
 * @author Ciro Formisano (ENG)
 *
 */
public class UsernamePasswordAuthenticationService extends AuthenticationInternalServiceImpl implements AuthenticationInternalService 
{
	private Log log;
	private String soa3Endpoint;

	public UsernamePasswordAuthenticationService(String soa3Endpoint) 
	{
		super ();
		this.soa3Endpoint = soa3Endpoint;
		this.log = LogFactory.getLog(this.getClass());
	}
	
	/*
	 * (non-Javadoc)
	 * @see it.eng.rdlab.soa3.connector.service.core.impl.AuthenticationInternalServiceImpl#askToSOA3(java.lang.String, long)
	 */
	@Override
	protected String askToSOA3(String id, long currentTime) 
	{
		log.debug("entry not found, calling SOA3");
		Authenticate soa3Authentication = new UsernamePasswordAuthentication(this.soa3Endpoint);
		UserBean response = soa3Authentication.authenticate(id);
		String ticket = null;
		
		if (response != null) 
		{
			log.debug("Login ok, generating the access control bean");
			AccessControlBean bean = new AccessControlBean();
			bean.setUsername(response.userName);
			bean.setSessionStart(currentTime);
			bean.setSessionEnd(currentTime+Configuration.getInstance().getAuthValidity());
			AccessControlManager.getInstance().setAccessControlBean(id, bean);
			log.debug("Access control bean added in the cache");
			ticket = UUID.randomUUID().toString();
			log.debug("Ticket = "+ticket);
			AccessControlManager.getInstance().setAccessControlBean(ticket, bean);
		}
		else
		{
			log.debug("Authentication failed: inserting new value in the black list");
			AccessControlManager.getInstance().setAccessDeniedEntry(id, currentTime+Configuration.getInstance().getAuthValidity());
			log.debug("Black list updated");
		}
		
		return ticket;
	}

}
