/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.soa3.connector.rest;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import it.eng.rdlab.soa3.connector.beans.ServiceResponse;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RestManager {
    private Log logger = LogFactory.getLog(this.getClass());
    private String soa3Endpoint;
    private Client client;
    private static Map<String, RestManager> instances = new HashMap<String, RestManager>();

    public static RestManager getInstance(String soa3Endpoint) {
        RestManager currentInstance = instances.get(soa3Endpoint);
        if (currentInstance == null) {
            currentInstance = new RestManager(soa3Endpoint);
            instances.put(soa3Endpoint, currentInstance);
        }
        return currentInstance;
    }

    private RestManager(String soa3Endpoint) {
        this.soa3Endpoint = soa3Endpoint;
        this.client = this.generateClient();
    }

    private Client generateClient() {
        this.logger.debug((Object)"creating client...");
        DefaultClientConfig config = new DefaultClientConfig();
        Client client = Client.create((ClientConfig)config);
        this.logger.debug((Object)"Client created");
        return client;
    }

    private WebResource generateWebResource(Client client, String completeUrl) {
        this.logger.debug((Object)"creating a web resource...");
        WebResource resource = client.resource(completeUrl);
        this.logger.debug((Object)"Web resource created");
        return resource;
    }

    private WebResource.Builder getRequest(WebResource resource, MediaType acceptMediaType, MediaType mediaType) {
        this.logger.debug((Object)"setting JSon accept header...");
        WebResource.Builder request = (WebResource.Builder)resource.accept(new MediaType[]{acceptMediaType}).type(mediaType);
        this.logger.debug((Object)"Accept header set");
        return request;
    }

    public synchronized <T extends ServiceResponse> T sendMessage(String path, Map<String, String> headers, String body, MediaType mediaType, MediaType acceptMediaType, Class<T> type) {
        this.logger.debug((Object)"Authentication service");
        String completeUrl = this.soa3Endpoint + "/" + path;
        WebResource authenticationResource = this.generateWebResource(this.client, completeUrl);
        WebResource.Builder authenticationBuilder = this.getRequest(authenticationResource, acceptMediaType, mediaType);
        this.logger.debug((Object)"Authentication web resource OK");
        for (String headerName : headers.keySet()) {
            String headerValue = headers.get(headerName);
            this.logger.debug((Object)("Adding header " + headerName + " value " + headerValue));
            authenticationBuilder = (WebResource.Builder)authenticationBuilder.header(headerName, (Object)headerValue);
            this.logger.debug((Object)"Header added");
        }
        this.logger.debug((Object)"Authentication builder OK");
        ClientResponse response = (ClientResponse)authenticationBuilder.get(ClientResponse.class);
        this.logger.debug((Object)("Response " + response));
        int status = response.getStatus();
        this.logger.debug((Object)("Status = " + status));
        try {
            ServiceResponse serviceResponse = (ServiceResponse)type.newInstance();
            serviceResponse.setResponseCode(status);
            if (status >= 200 && status < 300) {
                serviceResponse.importEntity(response);
                this.logger.debug((Object)("Response = " + serviceResponse));
            }
            return (T)serviceResponse;
        }
        catch (Exception e) {
            this.logger.fatal((Object)"Unexpected exception", (Throwable)e);
            return null;
        }
    }
}

