/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.soa3.connector.impl;

import it.eng.rdlab.soa3.connector.beans.UserBean;
import it.eng.rdlab.soa3.connector.beans.UserBeanResponse;
import java.util.HashMap;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.soa3.connector.Authenticate;
import org.gcube.soa3.connector.rest.RestManager;

public abstract class HeaderBasedAuthentication
implements Authenticate {
    private final String AUTHENTICATION_PATH = "authenticate";
    private final String HEADER = "Authorization";
    private String authenticationMethod;
    private String soa3Endpoint;
    private Log logger = LogFactory.getLog(this.getClass());

    public HeaderBasedAuthentication(String authenticationMethod, String soa3Endpoint) {
        this.authenticationMethod = authenticationMethod;
        this.soa3Endpoint = soa3Endpoint;
    }

    @Override
    public UserBean authenticate(String parameter) {
        this.logger.debug((Object)("Loading REST manager for " + this.soa3Endpoint));
        RestManager manager = RestManager.getInstance(this.soa3Endpoint);
        this.logger.debug((Object)"REST manager loaded");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", this.authenticationMethod + " " + parameter);
        UserBeanResponse response = manager.sendMessage("authenticate", headers, null, MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_JSON_TYPE, UserBeanResponse.class);
        int responseCode = response.getResponseCode();
        this.logger.debug((Object)("Response code " + responseCode));
        UserBean responseBean = null;
        if (responseCode < 300 && responseCode >= 200 && response.getResponse() != null) {
            responseBean = response.getResponse();
            this.logger.debug((Object)"Authentication OK ");
        } else {
            this.logger.debug((Object)"Authentication failed ");
        }
        return responseBean;
    }

    @Override
    public void setSoa3Endpoint(String soa3Endpoint) {
        this.soa3Endpoint = soa3Endpoint;
    }
}

