/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.soa3.connector.impl;

import it.eng.rdlab.soa3.connector.beans.StringResponse;
import it.eng.rdlab.soa3.connector.beans.UserBean;
import java.util.HashMap;
import javax.ws.rs.core.MediaType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.soa3.connector.Authenticate;
import org.gcube.soa3.connector.rest.RestManager;

public class DNAuthentication
implements Authenticate {
    private final String USERMANAGER_PATH = "userService/usermanager/certificate";
    private String soa3Endpoint;
    private Log logger = LogFactory.getLog(this.getClass());

    public DNAuthentication(String soa3Endpoint) {
        this.soa3Endpoint = soa3Endpoint;
    }

    @Override
    public void setSoa3Endpoint(String soa3Endpoint) {
        this.soa3Endpoint = soa3Endpoint;
    }

    @Override
    public UserBean authenticate(String parameter) {
        this.logger.debug((Object)("Loading REST manager for " + this.soa3Endpoint));
        RestManager manager = RestManager.getInstance(this.soa3Endpoint);
        this.logger.debug((Object)"REST manager loaded");
        String path = "userService/usermanager/certificate" + "/" + parameter + "/";
        StringResponse response = manager.sendMessage(path, new HashMap<String, String>(), null, MediaType.APPLICATION_JSON_TYPE, MediaType.APPLICATION_JSON_TYPE, StringResponse.class);
        int responseCode = response.getResponseCode();
        this.logger.debug((Object)("Response code " + responseCode));
        UserBean responseBean = null;
        if (responseCode < 300 && responseCode >= 200 && response.getResponse() != null) {
            try {
                String user = response.getResponse();
                this.logger.debug((Object)("User found " + user));
                responseBean = new UserBean(user);
                this.logger.debug((Object)"Authentication OK ");
            }
            catch (Exception e) {
                this.logger.debug((Object)"User not found", (Throwable)e);
            }
        } else {
            this.logger.debug((Object)"Authentication failed ");
        }
        return responseBean;
    }
}

