/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.connector.integration.server.context;

import java.util.ArrayList;
import org.gcube.common.core.security.GCUBEDefaultSecurityConfiguration;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.context.impl.DefaultGHNServerSecurityContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.security.soa3.configuration.ConfigurationManager;
import org.globus.wsrf.impl.security.descriptor.SecurityDescriptorException;
import org.globus.wsrf.impl.security.descriptor.ServiceSecurityDescriptor;

public class SOA3ServerSecurityContext
extends DefaultGHNServerSecurityContext {
    private GCUBELog log = new GCUBELog((Object)this);
    private GCUBEDefaultSecurityConfiguration configuration;
    private ServiceSecurityDescriptor secDesc;

    public SOA3ServerSecurityContext() {
        this.log.debug((Object)"Init soa3 client security context");
        this.configuration = new GCUBEDefaultSecurityConfiguration();
        this.configuration.setOutEnabled(true);
        this.configuration.setOutOverride(false);
        this.configuration.setDefaultCredentialPropagationSet(false);
        this.configuration.setPropagateCallerCredentials(ConfigurationManager.getInstance().getCredentialPropagationPolicy(null));
        this.configuration.setPropagateCallerCredentialsOverride(false);
        this.secDesc = new ServiceSecurityDescriptor();
        ArrayList<GCUBESecurityManager.AuthMethod> authMethods = new ArrayList<GCUBESecurityManager.AuthMethod>();
        authMethods.add(GCUBESecurityManager.AuthMethod.GSI_TRANS);
        try {
            this.secDesc.setAuthMethods(authMethods);
        }
        catch (SecurityDescriptorException e) {
            this.log.error((Object)"Unable complete the security descriptor", (Throwable)e);
        }
    }

    public GCUBEDefaultSecurityConfiguration getDefaultServiceSecurityConfiguration() {
        return this.configuration;
    }

    public ServiceSecurityDescriptor getDefaultIncomingMessagesSecurityDescriptor() {
        return this.secDesc;
    }

    public ServiceSecurityDescriptor getDefaultOutgoingMessagesSecurityDescriptor() {
        return this.secDesc;
    }
}

