/*
 * Decompiled with CFR 0.152.
 */
package it.rdlab.asserts.soa3.validate;

import it.rdlab.asserts.soa3.validate.AssertionValidationException;
import it.rdlab.asserts.soa3.validate.IAssertionValidator;
import it.rdlab.soa3.asserts.configuration.ConfigurationBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.opensaml.DefaultBootstrap;
import org.opensaml.common.xml.SAMLSchemaBuilder;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.ConfigurationException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureValidator;
import org.opensaml.xml.validation.ValidationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Assertionsvalidation
implements IAssertionValidator {
    private static Logger log = Logger.getLogger(Assertionsvalidation.class);
    private ConfigurationBean configuration;

    @Override
    public void configure(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    @Override
    public Assertion validateAssertions(String xml) throws AssertionValidationException, ConfigurationException {
        if (this.configuration == null) {
            throw new ConfigurationException("Null configuration");
        }
        Assertion assertion = this.getAssertionObject(xml);
        if (assertion == null) {
            log.error((Object)"Invalid XML!!!");
        } else if (!this.validateTimeInterval(assertion)) {
            log.debug((Object)"Invalid time interval");
            assertion = null;
        } else if (!this.validateSignature(assertion)) {
            log.debug((Object)"Invalid signature");
            assertion = null;
        }
        return assertion;
    }

    @Override
    public Assertion getAssertionObject(String assertionString) {
        log.debug((Object)"Generating assertion object...");
        try {
            log.debug((Object)"Parsing XML...");
            Document document = this.validateAndParse(assertionString);
            Element metadataRoot = document.getDocumentElement();
            log.debug((Object)"XML parsed");
            QName qName = new QName(metadataRoot.getNamespaceURI(), metadataRoot.getLocalName(), metadataRoot.getPrefix());
            log.debug((Object)"Getting unmarshaller...");
            Unmarshaller unmarshaller = Configuration.getUnmarshallerFactory().getUnmarshaller(qName);
            log.debug((Object)"Unmarshaller get, generating assertion...");
            Assertion response = (Assertion)unmarshaller.unmarshall(metadataRoot);
            log.debug((Object)"Assertion generated");
            return response;
        }
        catch (Exception e) {
            log.error((Object)"Unable to generate assertion object", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean validateTimeInterval(Assertion assertion) {
        log.debug((Object)"Evaluating timing conditions...");
        boolean response = true;
        Conditions conditions = assertion.getConditions();
        if (conditions != null) {
            log.debug((Object)"Comparing notBefore instant...");
            DateTime currentInstant = new DateTime();
            log.debug((Object)("Current instant = " + currentInstant));
            DateTime notBefore = conditions.getNotBefore();
            log.debug((Object)("Not before = " + notBefore));
            if (notBefore != null && currentInstant.isBefore((ReadableInstant)notBefore)) {
                response = false;
            } else {
                log.debug((Object)"Comparing notOnOrAfter instant...");
                DateTime notOnOrAfter = conditions.getNotOnOrAfter();
                log.debug((Object)("Not on or after = " + notOnOrAfter));
                if (notOnOrAfter != null && !currentInstant.isBefore((ReadableInstant)notOnOrAfter)) {
                    response = false;
                }
            }
        }
        log.debug((Object)("Time interval check completed with result " + response));
        return response;
    }

    @Override
    public boolean validateSignature(Assertion assertion) throws ConfigurationException {
        String confValue = this.configuration.getProperty("sign.validation.en");
        if (confValue != null && confValue.equalsIgnoreCase("false")) {
            log.debug((Object)"Signature validation disabled: the step will be skipped");
            return true;
        }
        log.debug((Object)"Signature validation enabled");
        String path = this.configuration.getProperty("public.key");
        if (path == null) {
            throw new ConfigurationException("Invalid ca cert path");
        }
        File signatureVerificationPublicKey = new File(path);
        ArrayList<File> signatureVerificationPublicKeyFiles = new ArrayList<File>();
        if (signatureVerificationPublicKey.isDirectory()) {
            File[] certFiles;
            log.debug((Object)"The inserted path is a directory");
            for (File certFile : certFiles = signatureVerificationPublicKey.listFiles()) {
                log.debug((Object)("File found " + certFile.getAbsolutePath()));
                signatureVerificationPublicKeyFiles.add(certFile);
            }
        } else {
            log.debug((Object)("the inserted path is a file " + path));
            signatureVerificationPublicKeyFiles.add(signatureVerificationPublicKey);
        }
        Signature signature = assertion.getSignature();
        log.debug((Object)("Signature Reference ID: " + signature.toString()));
        boolean valid = false;
        Iterator signatureVerificationPublicKeyFilesIterator = signatureVerificationPublicKeyFiles.iterator();
        while (signatureVerificationPublicKeyFilesIterator.hasNext() && !valid) {
            try {
                File signatureVerificationPublicKeyFile = (File)signatureVerificationPublicKeyFilesIterator.next();
                FileInputStream inputStream2 = new FileInputStream(signatureVerificationPublicKeyFile);
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream2);
                ((InputStream)inputStream2).close();
                X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(certificate.getPublicKey().getEncoded());
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                log.debug((Object)("Security Provider: " + keyFactory.getProvider().toString()));
                PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
                log.debug((Object)"Public Key created");
                BasicX509Credential publicCredential = new BasicX509Credential();
                publicCredential.setPublicKey(publicKey);
                SignatureValidator signatureValidator = new SignatureValidator((Credential)publicCredential);
                try {
                    signatureValidator.validate(signature);
                    log.debug((Object)"signature is valid");
                    valid = true;
                }
                catch (ValidationException e) {
                    log.debug((Object)"signature is not valid");
                }
            }
            catch (Exception e) {
                log.error((Object)"Certificate file not valid", (Throwable)e);
            }
        }
        log.debug((Object)("Validation process finished with result " + valid));
        return valid;
    }

    private Document validateAndParse(String xml) throws SAXException, XMLParserException, IOException {
        Schema schema = SAMLSchemaBuilder.getSAML11Schema();
        BasicParserPool parserPoolManager = new BasicParserPool();
        parserPoolManager.setNamespaceAware(true);
        parserPoolManager.setIgnoreElementContentWhitespace(true);
        parserPoolManager.setSchema(schema);
        Document document = parserPoolManager.getBuilder().parse(new InputSource(new StringReader(xml)));
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(document));
        return document;
    }

    static {
        try {
            DefaultBootstrap.bootstrap();
        }
        catch (ConfigurationException e) {
            log.error((Object)"Unable to perform opensaml bootstrap", (Throwable)e);
        }
    }
}

