/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.impl.simple;

import com.thoughtworks.xstream.XStream;
import java.util.List;
import java.util.Map;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.authorisation.control.impl.policies.GCUBEPolicy;
import org.gcube.common.vomanagement.security.authorisation.control.impl.policies.GCUBEPolicyEvaluationResponse;
import org.gcube.common.vomanagement.security.authorisation.core.PolicyEvaluationException;
import org.gcube.common.vomanagement.security.authorisation.core.PolicyEvaluationRequest;
import org.gcube.common.vomanagement.security.authorisation.core.PolicyEvaluationResponse;
import org.gcube.common.vomanagement.security.authorisation.core.PolicySerializationException;
import org.gcube.common.vomanagement.security.authorisation.core.impl.XStreamPolicySerializationHelper;
import org.gcube.common.vomanagement.security.authorisation.impl.simple.GCUBEGenericResourceAuthZPolicyPIP;

public class TrustedServicePolicy
implements GCUBEPolicy {
    protected GCUBELog logger = new GCUBELog((Object)this);
    private String serviceName;
    private String serviceClass;
    private XStreamPolicySerializationHelper helper = new XStreamPolicySerializationHelper(new XStream());
    private GCUBEServiceContext context;
    private GCUBEGenericResourceAuthZPolicyPIP genResAuthZPolicyPIP;

    @Override
    public void initialise(GCUBEServiceContext context, String policyContent) throws Exception {
        this.initialise(context);
    }

    @Override
    public void initialise(GCUBEServiceContext context) throws Exception {
        this.logger.info((Object)("initialising TrustedServicePolicy policy for service " + context.getServiceClass() + ":" + context.getName()));
        this.context = context;
        this.serviceClass = context.getServiceClass();
        this.serviceName = context.getName();
        this.genResAuthZPolicyPIP = GCUBEGenericResourceAuthZPolicyPIP.getInstance(context);
    }

    @Override
    public PolicyEvaluationResponse evaluate(PolicyEvaluationRequest authzRequest) throws PolicyEvaluationException {
        String operationRequested;
        Map<String, List<String>> trustedServicePoliciesMap = this.genResAuthZPolicyPIP.getTrustedServicePolicies(this.context.getScope(), this.serviceClass + ":" + this.serviceName);
        if (!trustedServicePoliciesMap.containsKey(operationRequested = authzRequest.getActionAttributes().get("action.name"))) {
            return new GCUBEPolicyEvaluationResponse(PolicyEvaluationResponse.RESPONSE.PERMIT);
        }
        List<String> trustedServices = trustedServicePoliciesMap.get(operationRequested);
        String caller = authzRequest.getSubjectAttributes().get("subject.caller");
        for (String trustedService : trustedServices) {
            if (!trustedService.equals(caller)) continue;
            this.logger.info((Object)("The caller service " + caller + " is a trusted service and is invoking the operation: " + operationRequested));
            return new GCUBEPolicyEvaluationResponse(PolicyEvaluationResponse.RESPONSE.PERMIT);
        }
        this.logger.info((Object)("The caller service " + caller + " is not authorised to invoke " + operationRequested));
        return new GCUBEPolicyEvaluationResponse(PolicyEvaluationResponse.RESPONSE.DENY);
    }

    public String toString() {
        return "TrustedServicePolicy";
    }

    @Override
    public String serialize() throws PolicySerializationException {
        return this.helper.getPolicyExpression(this.getClass().getCanonicalName(), this.context.getName() + ";" + this.context.getServiceClass());
    }
}

