/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.handlers;

import javax.xml.namespace.QName;
import javax.xml.rpc.handler.GenericHandler;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gcube.common.vomanagement.security.authorisation.handlers.utils.AttachmentUtils;
import org.gcube.common.vomanagement.security.authorisation.handlers.utils.SAMLAuthzAssertionTokenBuilder;
import org.globus.util.I18n;
import org.globus.wsrf.impl.security.authentication.wssec.GSSConfig;
import org.globus.wsrf.impl.security.authentication.wssec.WSSecurityFault;
import org.opensaml.SAMLAssertion;

public class SAMLAuthzAssertionHandler
extends GenericHandler {
    protected static I18n i18n = I18n.getI18n((String)"org.globus.wsrf.impl.security.authorization.errors");
    private static Log log = LogFactory.getLog((String)SAMLAuthzAssertionHandler.class.getName());

    public boolean handleRequest(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleResponse(MessageContext context) {
        return this.handleMessage((SOAPMessageContext)context);
    }

    public boolean handleMessage(SOAPMessageContext ctx) {
        Object obj = ctx.getProperty("org.globus.security.authorization.samlAssertion");
        if (obj == null) {
            log.debug((Object)"No assertion configured");
            return true;
        }
        log.debug((Object)"Assertion Object ");
        if (!(obj instanceof SAMLAssertion)) {
            log.warn((Object)"Property org.globus.security.authorization.samlAssertion does not have SAML Assertion instance");
            return true;
        }
        SAMLAssertion assertion = (SAMLAssertion)obj;
        SOAPMessage msg = ctx.getMessage();
        if (msg == null) {
            log.debug((Object)"No message");
            return true;
        }
        ctx.setProperty("axis.form.optimization", (Object)Boolean.TRUE);
        SOAPMessage newMsg = null;
        try {
            SAMLAuthzAssertionTokenBuilder builder = new SAMLAuthzAssertionTokenBuilder(assertion);
            SOAPEnvelope envelope = msg.getSOAPPart().getEnvelope();
            newMsg = builder.buildMessage(envelope);
        }
        catch (Exception e) {
            log.error((Object)i18n.getMessage("samlTokenErr"), (Throwable)e);
            throw WSSecurityFault.makeFault((Exception)e);
        }
        AttachmentUtils.copyAttachments(msg, newMsg);
        ctx.setMessage(newMsg);
        log.debug((Object)"Exit: SAMLAuthzAssertionHandler");
        return true;
    }

    public QName[] getHeaders() {
        return null;
    }

    static {
        GSSConfig.init();
    }
}

