/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.utils.messages;

import com.sun.xacml.Indenter;
import com.sun.xacml.attr.AnyURIAttribute;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.Subject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.XACMLConstants;
import org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.utils.messages.NamespaceAwareRequestCtx;

public class XACMLRequestBuilder
implements XACMLConstants {
    private GCUBELog logger = new GCUBELog((Object)this);
    private String action;
    private String resource;
    private String role;

    public void setAction(String action) {
        this.action = action;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setRole(String role) {
        this.role = role;
    }

    private Set<Subject> setupSubjects(String roleValue) throws URISyntaxException {
        this.logger.debug((Object)"Setting role values");
        HashSet<Subject> subjects = new HashSet<Subject>();
        URI roleId = new URI("urn:oasis:names:tc:xacml:2.0:subject:role");
        this.logger.debug((Object)"using role uri: urn:oasis:names:tc:xacml:2.0:subject:role");
        this.logger.debug((Object)("role value " + roleValue));
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        String roleUri = "urn:d4science:roles:role-values:" + roleValue;
        this.logger.debug((Object)("role uri " + roleUri));
        AnyURIAttribute value = new AnyURIAttribute(new URI(roleUri));
        attributes.add(new Attribute(roleId, null, null, (AttributeValue)value));
        subjects.add(new Subject(attributes));
        this.logger.debug((Object)"Role values set");
        return subjects;
    }

    private Set<Attribute> setupResource(String resourceName) throws URISyntaxException {
        this.logger.debug((Object)"setting resource value");
        HashSet<Attribute> resource = new HashSet<Attribute>();
        this.logger.debug((Object)("resource value " + resourceName));
        StringAttribute value = new StringAttribute(resourceName);
        resource.add(new Attribute(new URI("urn:oasis:names:tc:xacml:1.0:resource:resource-id"), null, null, (AttributeValue)value));
        this.logger.debug((Object)"Resource value set");
        return resource;
    }

    private Set<Attribute> setupAction(String actionValue) throws URISyntaxException {
        this.logger.debug((Object)"setting action value");
        HashSet<Attribute> action = new HashSet<Attribute>();
        this.logger.debug((Object)("action value " + actionValue));
        URI actionId = new URI("urn:oasis:names:tc:xacml:1.0:action:action-id");
        action.add(new Attribute(actionId, null, null, (AttributeValue)new StringAttribute(actionValue)));
        this.logger.debug((Object)"action value set");
        return action;
    }

    public NamespaceAwareRequestCtx generateRequest() throws Exception {
        if (this.role == null || this.resource == null || this.action == null) {
            this.logger.error((Object)("role  = " + this.role));
            this.logger.error((Object)("resource = " + this.resource));
            this.logger.error((Object)("action = " + this.action));
            throw new Exception("At least one parameter not valid");
        }
        this.logger.debug((Object)"Generating request...");
        Set<Subject> subjectSet = this.setupSubjects(this.role);
        Set<Attribute> resourcetSet = this.setupResource(this.resource);
        Set<Attribute> actionSet = this.setupAction(this.action);
        NamespaceAwareRequestCtx response = new NamespaceAwareRequestCtx(subjectSet, resourcetSet, actionSet, new HashSet<Attribute>());
        this.logger.debug((Object)"request generated");
        return response;
    }

    public static void main(String[] args) throws Exception {
        XACMLRequestBuilder builder = new XACMLRequestBuilder();
        builder.setAction("prova");
        builder.setResource("Argus");
        builder.setRole("ciro");
        NamespaceAwareRequestCtx request = builder.generateRequest();
        request.encode(System.out, new Indenter());
    }
}

