/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.control.impl.xacml;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.security.auth.Subject;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.authorisation.SAMLAssertionConstants;
import org.gcube.common.vomanagement.security.authorisation.control.AuthorizationConstants;
import org.globus.wsrf.impl.security.authorization.exceptions.AttributeException;
import org.globus.wsrf.impl.security.authorization.exceptions.CloseException;
import org.globus.wsrf.impl.security.authorization.exceptions.InitializeException;
import org.globus.wsrf.impl.security.util.AuthUtil;
import org.globus.wsrf.security.authorization.PDPConfig;
import org.globus.wsrf.security.authorization.PIP;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeStatement;

public class XACMLBasedPIP
implements PIP,
AuthorizationConstants,
SAMLAssertionConstants {
    private static final long serialVersionUID = 1L;
    private GCUBELog logger = new GCUBELog((Object)this);
    private boolean multiroleSupport;

    public void initialize(PDPConfig config, String name, String id) throws InitializeException {
        this.logger.debug((Object)("PIP  initialization for chain " + name));
        String multiroleSupportString = (String)config.getProperty(name, "multiRoleSupport");
        this.multiroleSupport = multiroleSupportString == null || !multiroleSupportString.equalsIgnoreCase("false");
        this.logger.debug((Object)("Multi role support " + this.multiroleSupport));
    }

    public void collectAttributes(Subject peer, MessageContext ctx, QName op) throws AttributeException {
        this.logger.debug((Object)"collecting attributes...");
        if (!this.addSubjectAttributes(peer, ctx, op)) {
            throw new AttributeException("No role in the assertion");
        }
        if (!this.addActionAttribute(peer, ctx, op)) {
            throw new AttributeException("Unable to find the action");
        }
        if (!this.addResourceAttribute(peer, ctx, op)) {
            throw new AttributeException("Unable to find the resource");
        }
        this.logger.debug((Object)"attributes collected");
    }

    protected boolean addSubjectAttributes(Subject peer, MessageContext ctx, QName op) {
        this.logger.debug((Object)"adding subject attributes...");
        boolean result = false;
        SAMLAssertion assertion = (SAMLAssertion)ctx.getProperty("org.globus.security.authorization.samlAssertion");
        if (assertion == null) {
            this.logger.error((Object)"SAML Assertion not found");
        } else {
            Iterator statementsIterator = assertion.getStatements();
            this.logger.debug((Object)"Statements iterator retrieved");
            if (statementsIterator.hasNext()) {
                SAMLAttributeStatement statement = (SAMLAttributeStatement)statementsIterator.next();
                this.logger.debug((Object)("Statement " + statement.getSubject().getName()));
                Iterator attributes = statement.getAttributes();
                Iterator roleValues = null;
                while (attributes.hasNext() && roleValues == null) {
                    SAMLAttribute roleAttribute = (SAMLAttribute)attributes.next();
                    String name = roleAttribute.getName();
                    this.logger.debug((Object)("Attribute name = " + name));
                    if (!name.equals("role.id")) continue;
                    roleValues = roleAttribute.getValues();
                    this.logger.debug((Object)("Role values empty " + (roleValues == null)));
                }
                if (roleValues == null) {
                    this.logger.error((Object)"Roles attributes not found");
                } else {
                    boolean firstCycle = true;
                    this.logger.debug((Object)("More than a role cycle = " + (this.multiroleSupport || firstCycle)));
                    while (roleValues.hasNext() && (this.multiroleSupport || firstCycle)) {
                        String roleValue = (String)roleValues.next();
                        this.logger.debug((Object)("Role: " + roleValue));
                        if (this.logger.isWarnEnabled() && roleValues.hasNext()) {
                            this.logger.warn((Object)"Extra roles ignored");
                        }
                        ctx.setProperty("Role_value", (Object)roleValue);
                        firstCycle = false;
                    }
                    this.logger.debug((Object)"Roles values iterator inserted in the context");
                    result = true;
                }
            } else {
                this.logger.error((Object)"SAML Assertion statement not found");
            }
        }
        this.logger.debug((Object)"end");
        return result;
    }

    protected boolean addActionAttribute(Subject peer, MessageContext ctx, QName opQName) {
        this.logger.debug((Object)"collectActionAttributes] start");
        String operationName = null;
        if (opQName != null) {
            operationName = opQName.getLocalPart();
            this.logger.debug((Object)("Operation being invoked " + operationName));
            ctx.setProperty("Action_attr", (Object)operationName);
            this.logger.debug((Object)"end");
            return true;
        }
        this.logger.warn((Object)"No action attribute found");
        return false;
    }

    protected boolean addResourceAttribute(Subject peer, MessageContext context, QName opQName) {
        this.logger.debug((Object)"adding resource attribute");
        org.apache.axis.MessageContext ctx = (org.apache.axis.MessageContext)context;
        try {
            URL resource = AuthUtil.getEndpointAddressURL((MessageContext)ctx);
            if (resource != null) {
                String servicePath = resource.getPath();
                this.logger.debug((Object)("Resource being accessed is " + servicePath));
                ctx.setProperty("Resource_attr", (Object)servicePath);
                this.logger.debug((Object)"end");
                return true;
            }
        }
        catch (MalformedURLException e) {
            this.logger.error((Object)"Invalid url", (Throwable)e);
        }
        this.logger.warn((Object)"No resource found");
        return false;
    }

    public void close() throws CloseException {
        this.logger.debug((Object)"PIP closed");
    }
}

