/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.utils.soap;

import com.sun.xacml.ParsingException;
import com.sun.xacml.ctx.ResponseCtx;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.utils.messages.ResponseContextFactory;
import org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.utils.soap.LowLevelSoapConnectionEngine;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SoapConnectionEngine
implements LowLevelSoapConnectionEngine {
    private String targetUrl;
    private Document bodyDocument;
    private GCUBELog logger = new GCUBELog((Object)this);

    @Override
    public void setTargetUrl(String targetUrl) {
        this.targetUrl = targetUrl;
    }

    @Override
    public void setBodyDocument(Document bodyDocument) {
        this.bodyDocument = bodyDocument;
    }

    @Override
    public ResponseCtx sendMessage() throws Exception {
        this.logger.debug((Object)("Sending authorization request to " + this.targetUrl));
        SOAPMessage soapMessage = this.generateSoapMessage(this.bodyDocument);
        this.logger.debug((Object)"soap message generated");
        SOAPConnection conn = SOAPConnectionFactory.newInstance().createConnection();
        this.logger.debug((Object)"soap connection created");
        SOAPMessage response = conn.call(soapMessage, (Object)this.targetUrl);
        this.logger.debug((Object)"response received");
        SOAPBody resBody = response.getSOAPBody();
        this.logger.debug((Object)"body received");
        NodeList responseNodes = resBody.getElementsByTagNameNS("urn:oasis:names:tc:xacml:2.0:context:schema:os", "Response");
        this.logger.debug((Object)"Response object obtained");
        if (responseNodes.getLength() == 0) {
            conn.close();
            throw new ParsingException("No Response nodes");
        }
        ResponseCtx responseCtx = ResponseContextFactory.generateResponseCtx((Element)responseNodes.item(0));
        this.logger.debug((Object)"response context created");
        conn.close();
        return responseCtx;
    }

    private SOAPMessage generateSoapMessage(Document document) throws Exception {
        this.logger.debug((Object)"Generating soap message");
        Element xacmlQueryElement = document.getDocumentElement();
        SOAPMessage soapmsg = MessageFactory.newInstance().createMessage();
        SOAPFactory sf = SOAPFactory.newInstance();
        SOAPElement bodyelement = sf.createElement(xacmlQueryElement);
        this.logger.debug((Object)"Query Element added");
        soapmsg.getSOAPBody().addChildElement(bodyelement);
        soapmsg.saveChanges();
        this.logger.debug((Object)"Message completed");
        return soapmsg;
    }
}

