/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.utils.messages;

import com.sun.xacml.Indenter;
import com.sun.xacml.ctx.ResponseCtx;
import java.io.OutputStream;
import java.security.SecureRandom;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.utils.messages.NamespaceAwareRequestCtx;
import org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.utils.messages.XACMLRequestBuilder;
import org.gcube.common.vomanagement.security.authorisation.control.impl.xacml.utils.soap.SoapAxisConnectionEngine;
import org.gcube.common.vomanagement.security.authorisation.utils.Utils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XACMLAuthzDecisionQueryBuilder {
    private final String DECISION_QUERY_ELEMENT = "XACMLAuthzDecisionQuery";
    private final String RETURN_CONTEXT = "ReturnContext";
    private final String COMBINE_POLICIES = "CombinePolicies";
    private final String ID = "ID";
    private final String INPUT_CONTEXT_ONLY = "InputContextOnly";
    private final String VERSION = "Version";
    private final String DEC_QUERY_NAMESPACE = "urn:oasis:names:tc:xacml:2.0:profile:saml2.0:v2:schema:protocol";
    public static final String VERSION_20 = "2.0";
    private boolean returnContext = false;
    private boolean combinePolicies = true;
    private boolean inputContextOnly = false;
    private String version = "2.0";
    private String id;
    private GCUBELog logger = new GCUBELog((Object)this);

    public XACMLAuthzDecisionQueryBuilder() {
        this.id = "_" + Utils.getHex(this.genSecRandom());
    }

    public void setReturnContext(boolean returnContext) {
        this.returnContext = returnContext;
    }

    public void setCombinePolicies(boolean combinePolicies) {
        this.combinePolicies = combinePolicies;
    }

    public void setInputContextOnly(boolean inputContextOnly) {
        this.inputContextOnly = inputContextOnly;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setId(String id) {
        this.id = id;
    }

    private byte[] genSecRandom() {
        SecureRandom ranGen = new SecureRandom();
        byte[] aesKey = new byte[16];
        ranGen.nextBytes(aesKey);
        return aesKey;
    }

    public Document generateAuthzQuery(NamespaceAwareRequestCtx requestContext) throws Exception {
        this.logger.debug((Object)"Generating authz query...");
        DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        this.logger.debug((Object)"Document generated");
        Element queryElement = doc.createElementNS("urn:oasis:names:tc:xacml:2.0:profile:saml2.0:v2:schema:protocol", "XACMLAuthzDecisionQuery");
        this.logger.debug((Object)"Query Element generated");
        if (this.returnContext) {
            queryElement.setAttribute("ReturnContext", "true");
        }
        if (!this.combinePolicies) {
            queryElement.setAttribute("CombinePolicies", "false");
        }
        if (this.inputContextOnly) {
            queryElement.setAttribute("InputContextOnly", "true");
        }
        queryElement.setAttribute("ID", this.id);
        queryElement.setAttribute("Version", this.version);
        doc.appendChild(queryElement);
        this.logger.debug((Object)"Attributes set");
        requestContext.insertIntoDocument(queryElement);
        return doc;
    }

    public static void main(String[] args) throws Exception {
        XACMLAuthzDecisionQueryBuilder queryBuilder = new XACMLAuthzDecisionQueryBuilder();
        XACMLRequestBuilder builder = new XACMLRequestBuilder();
        builder.setAction("prova");
        builder.setResource("Argus");
        builder.setRole("ciro");
        Document request = queryBuilder.generateAuthzQuery(builder.generateRequest());
        SoapAxisConnectionEngine connection = new SoapAxisConnectionEngine();
        connection.setTargetUrl("https://CiroMobile:8152/authz");
        connection.setBodyDocument(request);
        ResponseCtx response = connection.sendMessage();
        response.encode((OutputStream)System.out, new Indenter());
    }
}

