/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.control.impl.policies;

import java.util.HashMap;
import java.util.Map;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.authorisation.core.PolicyEvaluationRequest;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;

public class GCUBEPolicyEvaluationRequest
implements PolicyEvaluationRequest {
    protected GCUBELog logger = new GCUBELog((Object)this);
    public static final String ENVIRONMENT_SCOPE = "environment.scope";
    public static final String RESOURCE_NAME = "resource.name";
    public static final String ACTION_NAME = "action.name";
    public static final String SUBJECT_NAME = "subject.name";
    public static final String SUBJECT_DN = "subject.dn";
    public static final String SUBJECT_CA = "subject.ca";
    public static final String SUBJECT_CALLER = "subject.caller";
    Map<String, String> environmentAttributes = new HashMap<String, String>();
    Map<String, String> resourceAttributes = new HashMap<String, String>();
    Map<String, String> actionAttributes = new HashMap<String, String>();
    Map<String, String> subjectAttributes = new HashMap<String, String>();

    public GCUBEPolicyEvaluationRequest(Map<String, Object> paramsMap) {
        this.logger.info((Object)("Creating GCUBEPolicyEvaluationRequest from call: " + paramsMap.get("NAME")));
        this.addScopeAttribute((GCUBEScope)paramsMap.get("SCOPE"));
        this.addResourceNameAttribute((GCUBEServiceContext)paramsMap.get("TARGET_SERVICE"));
        this.addActionNameAttribute((String)paramsMap.get("OPERATION"));
        this.addCallerNameAttribute((String)paramsMap.get("CALLER"));
    }

    private void addAttribute(String attributeKey, String attributeValue, Map<String, String> attributeMap) {
        attributeMap.put(attributeKey, attributeValue);
        this.logger.debug((Object)("The attribute " + attributeKey + "=" + attributeValue + " has been added to the GCUBEPolicy evaluation request"));
    }

    @Override
    public Map<String, String> getResourceAttributes() {
        return this.resourceAttributes;
    }

    public void setResourceAttributes(Map<String, String> resourceAttributes) {
        this.resourceAttributes = resourceAttributes;
    }

    @Override
    public Map<String, String> getActionAttributes() {
        return this.actionAttributes;
    }

    public void setActionAttributes(Map<String, String> actionAttributes) {
        this.actionAttributes = actionAttributes;
    }

    @Override
    public Map<String, String> getSubjectAttributes() {
        return this.subjectAttributes;
    }

    public void setSubjectAttributes(Map<String, String> subjectAttributes) {
        this.subjectAttributes = subjectAttributes;
    }

    @Override
    public Map<String, String> getEnvironmentAttributes() {
        return this.environmentAttributes;
    }

    public void setEnvironmentAttributes(Map<String, String> environmentAttributes) {
        this.environmentAttributes = environmentAttributes;
    }

    public void setSubjectName(GSSCredential subject) {
        try {
            this.addAttribute(SUBJECT_NAME, ((Object)subject.getName()).toString(), this.subjectAttributes);
        }
        catch (GSSException e) {
            e.printStackTrace();
        }
    }

    public void addScopeAttribute(GCUBEScope scope) {
        this.addAttribute(ENVIRONMENT_SCOPE, scope.getName(), this.environmentAttributes);
    }

    public void addActionNameAttribute(String action) {
        this.addAttribute(ACTION_NAME, action, this.actionAttributes);
    }

    public void addResourceNameAttribute(GCUBEServiceContext targetService) {
        this.addAttribute(RESOURCE_NAME, targetService.getID(), this.resourceAttributes);
    }

    public void addSubjectDNAttribute(String dn) {
        this.addAttribute(SUBJECT_DN, dn, this.subjectAttributes);
    }

    public void addSubjectCAAttribute(String ca) {
        this.addAttribute(SUBJECT_CA, ca, this.subjectAttributes);
    }

    private void addCallerNameAttribute(String caller) {
        String[] parts = caller.split(":");
        if (parts.length >= 3) {
            this.addAttribute(SUBJECT_CALLER, parts[0] + ":" + parts[1], this.subjectAttributes);
        }
    }
}

