/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.authorisation.control;

import java.security.Principal;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.axis.MessageContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.security.GCUBEServiceAuthorizationController;
import org.gcube.common.core.security.GCUBEServiceSecurityManager;
import org.gcube.common.core.security.impl.GCUBEAuthzChainAuthorizationController;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.vomanagement.security.authorisation.control.utils.IdentityProviderManager;
import org.gcube.common.vomanagement.security.authorisation.control.utils.bean.IdentityBean;
import org.gcube.common.vomanagement.security.authorisation.utils.AssertionGenerator;
import org.gcube.common.vomanagement.security.authorisation.utils.Utils;
import org.gcube.vomanagement.utils.ehcache.AssertionEhcacheWrapper;
import org.globus.gsi.gssapi.auth.AuthorizationException;
import org.globus.wsrf.config.ConfigException;
import org.opensaml.SAMLAssertion;

public class IncomingMessageEdgeServiceDNAuthorizationController
implements GCUBEServiceAuthorizationController {
    private GCUBEServiceSecurityManager securityManager;
    private GCUBELog logger = new GCUBELog((Object)this);
    private GCUBEServiceAuthorizationController internalController;
    private IdentityProviderManager identityProviderManager;
    public static final String IDENTITY_SERVICE_URL = "identityServiceUrl";

    public void initialise(GCUBEServiceContext ctxt, GCUBEServiceSecurityManager securityManager) throws Exception {
        this.securityManager = securityManager;
        this.internalController = new GCUBEAuthzChainAuthorizationController();
        this.internalController.initialise(ctxt, securityManager);
        String identityServiceUrl = this.getIdentityServiceUrl(ctxt);
        if (identityServiceUrl == null) {
            throw new ConfigException("Identity provider service url not configured");
        }
        this.identityProviderManager = new IdentityProviderManager(identityServiceUrl);
    }

    private String getIdentityServiceUrl(GCUBEServiceContext serviceContext) {
        this.logger.debug((Object)"Finding identity provider url...");
        String identityServiceUrl = (String)serviceContext.getProperty(IDENTITY_SERVICE_URL, new boolean[0]);
        if (identityServiceUrl == null) {
            this.logger.debug((Object)"Identity service not found in service JNDI, trying in the global JNDI");
            identityServiceUrl = (String)GHNContext.getContext().getProperty(IDENTITY_SERVICE_URL, new boolean[0]);
            if (identityServiceUrl == null) {
                this.logger.error((Object)"Identity provider url not found");
            } else {
                this.logger.debug((Object)("Identity provider service " + identityServiceUrl));
            }
        } else {
            this.logger.debug((Object)("Identity provider service " + identityServiceUrl));
        }
        return identityServiceUrl;
    }

    public boolean isSecurityEnabled() {
        return this.securityManager.isSecurityEnabled();
    }

    public void authoriseCall(Map<String, Object> parameters) throws GCUBEException {
        this.logger.debug((Object)"External request authorization process");
        if (this.isSecurityEnabled()) {
            MessageContext messageContext = (MessageContext)parameters.get("MESSAGE_CONTEXT");
            if (messageContext == null) {
                this.logger.error((Object)"Unable to find message context");
                throw new GCUBEUnrecoverableException("Unable to find message context");
            }
            Subject subject = (Subject)messageContext.getProperty("callerSubject");
            if (subject == null) {
                this.logger.error((Object)"Unable to find calling subject");
                throw new GCUBEUnrecoverableException("Unable to find calling subject");
            }
            this.logger.debug((Object)("External calling subject " + subject));
            Set<Principal> principals = subject.getPrincipals();
            if (principals == null) {
                this.logger.error((Object)"Unable to find subject identity");
                throw new GCUBEUnrecoverableException("Unable to find subject identity");
            }
            this.logger.debug((Object)"Finding the identity assertion");
            SAMLAssertion assertion = this.findIdentity(principals);
            if (assertion == null) {
                this.logger.error((Object)"Unable to find the assertion");
                throw new GCUBEUnrecoverableException((Throwable)new AuthorizationException("Unable to find an identity"));
            }
            messageContext.setProperty("org.globus.security.authorization.samlAssertion", (Object)assertion);
            this.internalController.authoriseCall(parameters);
        } else {
            this.logger.debug((Object)"Security not enabled, nothing to do");
        }
    }

    private SAMLAssertion findIdentity(Set<Principal> principals) {
        this.logger.debug((Object)"Finding Identity Assertion...");
        SAMLAssertion foundAssertion = this.findAssertionFromCache(principals);
        if (foundAssertion != null) {
            this.logger.debug((Object)"Assertion found in the cache");
        } else {
            this.logger.debug((Object)"lookup the user database");
            foundAssertion = this.findAssertionFromUsersDatabase(principals);
            this.logger.debug((Object)("Assertion = " + foundAssertion));
        }
        return foundAssertion;
    }

    private SAMLAssertion findAssertionFromCache(Set<Principal> principals) {
        this.logger.debug((Object)"Searching assertion from cache");
        Iterator<Principal> principalsIterator = principals.iterator();
        SAMLAssertion foundAssertion = null;
        while (principalsIterator.hasNext() && foundAssertion == null) {
            Principal principal = principalsIterator.next();
            String dn = principal.getName();
            this.logger.debug((Object)("Searching for a SAML Assertion for the DN " + dn));
            String assertionString = AssertionEhcacheWrapper.getInstance().get(dn);
            try {
                if (assertionString == null) {
                    this.logger.debug((Object)"Assertion not found");
                    continue;
                }
                this.logger.debug((Object)"Generate the assertion");
                SAMLAssertion assertion = new SAMLAssertion(Utils.stringToElement((String)assertionString));
                this.logger.debug((Object)"Assertion found checking the expiration date");
                boolean accepted = this.checkDate(assertion.getNotBefore(), assertion.getNotOnOrAfter());
                if (accepted) {
                    this.logger.debug((Object)"Assetion accepted");
                    foundAssertion = assertion;
                    continue;
                }
                this.logger.debug((Object)"Assertion not accepted");
            }
            catch (Exception e) {
                this.logger.error((Object)"Exception in rigenerate the SAML assertion", (Throwable)e);
            }
        }
        return foundAssertion;
    }

    private boolean checkDate(Date startDate, Date endDate) {
        this.logger.debug((Object)"Checking assertion expiration time");
        long startLongDate = startDate.getTime();
        this.logger.debug((Object)("Start time = " + startLongDate));
        long endLongDate = endDate.getTime();
        this.logger.debug((Object)("End time = " + endLongDate));
        long currentTime = new Date().getTime();
        this.logger.debug((Object)("Current time = " + currentTime));
        long middle = (endLongDate - startLongDate) / 2L;
        long middletime = startLongDate + middle;
        this.logger.debug((Object)("Middle time = " + middletime));
        if (currentTime > middletime) {
            this.logger.debug((Object)"The assertion will expire in less than half of its lifetime: it will be rejected");
            return false;
        }
        this.logger.debug((Object)"The assertion will be used");
        return true;
    }

    private SAMLAssertion findAssertionFromUsersDatabase(Set<Principal> principals) {
        this.logger.debug((Object)"Asking user database for identity");
        Iterator<Principal> principalsIterator = principals.iterator();
        SAMLAssertion foundAssertion = null;
        while (principalsIterator.hasNext() && foundAssertion == null) {
            Principal principal = principalsIterator.next();
            String dn = principal.getName();
            this.logger.debug((Object)("Searching for a SAML Assertion for the DN " + dn));
            try {
                foundAssertion = this.askToIdp(dn);
            }
            catch (Exception e) {
                this.logger.error((Object)("Problem in getting identity information for identity " + dn + " from service " + this.identityProviderManager.getIdentityServiceUrl()), (Throwable)e);
            }
            if (foundAssertion == null) continue;
            this.logger.debug((Object)"Assertion found");
            AssertionEhcacheWrapper.getInstance().put(dn, foundAssertion.toString());
        }
        return foundAssertion;
    }

    private SAMLAssertion askToIdp(String dn) throws Exception {
        this.logger.debug((Object)"Asking to the Identity service");
        IdentityBean identityBean = this.identityProviderManager.getIdentity(dn);
        SAMLAssertion response = null;
        if (identityBean == null) {
            this.logger.debug((Object)("identity " + dn + " not found"));
        } else {
            this.logger.debug((Object)("Generating SAML Assertion with identity " + identityBean.getUserId()));
            AssertionGenerator assertionGenerator = new AssertionGenerator();
            assertionGenerator.setUserId(identityBean.getUserId());
            assertionGenerator.setRoleList(identityBean.getRoles());
            response = assertionGenerator.generateSignedAssertion();
            this.logger.debug((Object)("Assertion = " + response.toString()));
        }
        return response;
    }
}

