/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.contexts.impl.entities;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonSetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.informationsystem.base.impl.entities.EntityElementImpl;
import org.gcube.informationsystem.contexts.impl.relations.IsParentOfImpl;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.contexts.reference.relations.IsParentOf;
import org.gcube.informationsystem.model.impl.properties.MetadataImpl;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.gcube.informationsystem.utils.UUIDManager;

@JsonTypeName(value="Context")
public class ContextImpl
extends EntityElementImpl
implements Context {
    private static final long serialVersionUID = -5070590328223454087L;
    protected String name;
    protected String state;
    protected IsParentOf parent = null;
    protected List<IsParentOf> children = new ArrayList<IsParentOf>();
    @JsonIgnore
    protected Map<String, Object> additionalProperties = new HashMap<String, Object>();
    @JsonIgnore
    protected final Set<String> allowedAdditionalKeys = new HashSet<String>();

    protected ContextImpl() {
    }

    public ContextImpl(UUID uuid) {
        this(null, uuid);
    }

    public ContextImpl(String name) {
        this(name, null);
    }

    public ContextImpl(String name, UUID uuid) {
        this();
        this.name = name;
        if (uuid == null) {
            uuid = UUIDManager.getInstance().generateValidUUID();
        }
        this.uuid = uuid;
        this.metadata = new MetadataImpl();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public void setState(String state) {
        this.state = state;
    }

    @Override
    public IsParentOf getParent() {
        return this.parent;
    }

    @Override
    public void setParent(UUID uuid) {
        ContextImpl parent = null;
        if (uuid != null) {
            parent = new ContextImpl(uuid);
            parent.setMetadata(new MetadataImpl());
        }
        this.setParent(parent);
    }

    @Override
    public void setParent(Context context) {
        IsParentOfImpl isParentOf = null;
        if (context != null) {
            isParentOf = new IsParentOfImpl(context, this);
        }
        this.setParent(isParentOf);
    }

    @JsonSetter(value="parent")
    protected void setParentFromJson(IsParentOf isParentOf) throws JsonProcessingException {
        if (isParentOf != null) {
            Context parent = isParentOf.getSource();
            isParentOf.setTarget(this);
            ((ContextImpl)parent).addChild(isParentOf);
        }
        this.setParent(isParentOf);
    }

    @Override
    public void setParent(IsParentOf isParentOf) {
        this.parent = isParentOf;
    }

    @Override
    public List<IsParentOf> getChildren() {
        return this.children;
    }

    @JsonSetter(value="children")
    protected void setChildrenFromJson(List<IsParentOf> children) throws JsonProcessingException {
        for (IsParentOf isParentOf : children) {
            this.addChildFromJson(isParentOf);
        }
    }

    protected void addChildFromJson(IsParentOf isParentOf) throws JsonProcessingException {
        isParentOf.setSource(this);
        this.addChild(isParentOf);
    }

    @Override
    public void addChild(UUID uuid) {
        ContextImpl child = new ContextImpl(uuid);
        child.setMetadata(new MetadataImpl());
        this.addChild(child);
    }

    @Override
    public void addChild(Context child) {
        IsParentOfImpl isParentOf = new IsParentOfImpl(this, child);
        this.addChild(isParentOf);
    }

    @Override
    public void addChild(IsParentOf isParentOf) {
        isParentOf.setSource(this);
        this.children.add(isParentOf);
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    @Override
    public Object getAdditionalProperty(String key) {
        return this.additionalProperties.get(key);
    }

    @Override
    public void setAdditionalProperty(String key, Object value) {
        if (!this.allowedAdditionalKeys.contains(key)) {
            if (key.startsWith("_")) {
                return;
            }
            if (key.startsWith("@")) {
                return;
            }
        }
        try {
            Map map;
            if (value instanceof Map && (map = (Map)value).containsKey("type")) {
                String reserialized = ElementMapper.getObjectMapper().writeValueAsString((Object)map);
                Property property = ElementMapper.unmarshal(Property.class, reserialized);
                value = property;
            }
        }
        catch (Throwable e) {
            e.getMessage();
        }
        this.additionalProperties.put(key, value);
    }
}

