/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.security.secrets;

import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.common.iam.D4ScienceJWTObject;
import org.gcube.common.iam.OIDCBearerAuth;
import org.gcube.common.security.Owner;
import org.gcube.common.security.secrets.Secret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmaTokenSecret
extends Secret {
    private static final Logger log = LoggerFactory.getLogger(UmaTokenSecret.class);
    public static final int KEYCLOAK_BASED_SECRET_PRIORITY = 20;
    private static final String AUTH_HEADER = "Authorization";
    private static final String USER_HEADER = "d4s-user";
    private String encodedUmaToken;
    private Owner owner;
    private String context;
    private D4ScienceJWTObject accessToken;
    private boolean initialised = false;

    public UmaTokenSecret(String encodedUmaToken) {
        this.encodedUmaToken = encodedUmaToken;
    }

    public int priority() {
        return 20;
    }

    public Owner getOwner() {
        this.init();
        return this.owner;
    }

    public String getContext() {
        this.init();
        return this.context;
    }

    public Map<String, String> getHTTPAuthorizationHeaders() {
        HashMap<String, String> authorizationHeaders = new HashMap<String, String>();
        authorizationHeaders.put(AUTH_HEADER, "Bearer " + this.encodedUmaToken);
        String encodedUser = Base64.getEncoder().encodeToString(this.getOwner().getId().getBytes());
        authorizationHeaders.put(USER_HEADER, encodedUser);
        return authorizationHeaders;
    }

    protected String getEncodedUmaToken() {
        return this.encodedUmaToken;
    }

    public boolean isExpired() {
        this.init();
        return this.accessToken.isExpired();
    }

    private synchronized void init() {
        if (!this.initialised) {
            try {
                String realAccessTokenEncoded = this.encodedUmaToken.split("\\.")[1];
                String decodedAccessPart = new String(Base64.getDecoder().decode(realAccessTokenEncoded.getBytes()));
                ObjectMapper objectMapper = new ObjectMapper();
                this.accessToken = (D4ScienceJWTObject)objectMapper.readValue(decodedAccessPart, D4ScienceJWTObject.class);
                this.owner = new Owner(this.accessToken.getUsername(), this.accessToken.getRoles(), this.accessToken.getRealmRoles(), this.accessToken.getEmail(), this.accessToken.getGivenName(), this.accessToken.getFamilyName(), this.accessToken.isExternalService(), this.accessToken.isApplication());
                this.owner.setClientName(this.accessToken.getClientName());
                this.owner.setContactOrganisation(this.accessToken.getContactOrganisation());
                this.context = this.accessToken.getContext();
                this.initialised = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean isValid() {
        this.init();
        try {
            return OIDCBearerAuth.fromAccessTokenString((String)this.encodedUmaToken).isAccessTokenValid(false);
        }
        catch (Exception e) {
            log.error("Error checking token validity", (Throwable)e);
            return false;
        }
    }
}

