/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.authorization.library.policies;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Calendar;
import org.gcube.common.authorization.library.policies.Action;
import org.gcube.common.authorization.library.policies.Policy;
import org.gcube.common.authorization.library.policies.PolicyType;
import org.gcube.common.authorization.library.policies.Role;
import org.gcube.common.authorization.library.policies.ServiceAccess;
import org.gcube.common.authorization.library.policies.User;
import org.gcube.common.authorization.library.policies.UserEntity;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class User2ServicePolicy
extends Policy {
    @XmlElementRefs(value={@XmlElementRef(type=User.class), @XmlElementRef(type=Role.class)})
    private UserEntity entity;
    private String context;
    private ServiceAccess serviceAccess;
    private Calendar lastUpdateTime;
    private Calendar creationTime;
    private Action mode = Action.ALL;

    protected User2ServicePolicy() {
    }

    public User2ServicePolicy(String context, ServiceAccess serviceAccess, UserEntity entity) {
        this.context = context;
        this.serviceAccess = serviceAccess;
        this.entity = entity;
    }

    public User2ServicePolicy(String context, ServiceAccess serviceAccess, UserEntity entity, Action mode) {
        this(context, serviceAccess, entity);
        this.mode = mode;
    }

    public UserEntity getEntity() {
        return this.entity;
    }

    @Override
    public ServiceAccess getServiceAccess() {
        return this.serviceAccess;
    }

    @Override
    public PolicyType getPolicyType() {
        return PolicyType.USER;
    }

    @Override
    public String getPolicyAsString() {
        return this.context + "," + this.serviceAccess.getAsString() + "," + this.entity.getAsString() + "," + this.mode.toString();
    }

    @Override
    public String getContext() {
        return this.context;
    }

    @Override
    public Calendar getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public Calendar getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void setLastUpdateTime(Calendar lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Override
    public void setCreationTime(Calendar creationTime) {
        this.creationTime = creationTime;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.entity == null ? 0 : this.entity.hashCode());
        result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
        result = 31 * result + (this.serviceAccess == null ? 0 : this.serviceAccess.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User2ServicePolicy other = (User2ServicePolicy)obj;
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        if (this.entity == null ? other.entity != null : !this.entity.equals(other.entity)) {
            return false;
        }
        if (this.mode != other.mode) {
            return false;
        }
        return !(this.serviceAccess == null ? other.serviceAccess != null : !this.serviceAccess.equals(other.serviceAccess));
    }

    public String toString() {
        return "User2ServicePolicy [entity=" + String.valueOf(this.entity) + ", context=" + this.context + ", serviceAccess=" + String.valueOf(this.serviceAccess) + ", lastUpdateTime=" + String.valueOf(this.lastUpdateTime) + ", creationTime=" + String.valueOf(this.creationTime) + ", mode=" + String.valueOf((Object)this.mode) + "]";
    }

    @Override
    public Action getMode() {
        return this.mode;
    }
}

