/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.lang;

import java.util.Collection;
import org.gcube.io.jsonwebtoken.Identifiable;
import org.gcube.io.jsonwebtoken.impl.lang.Function;
import org.gcube.io.jsonwebtoken.impl.lang.StringRegistry;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Strings;

public class IdRegistry<T extends Identifiable>
extends StringRegistry<T> {
    public static final Function<Identifiable, String> FN = new Function<Identifiable, String>(){

        @Override
        public String apply(Identifiable identifiable) {
            Assert.notNull((Object)identifiable, (String)"Identifiable argument cannot be null.");
            return (String)Assert.notNull((Object)Strings.clean((String)identifiable.getId()), (String)"Identifier cannot be null or empty.");
        }
    };

    public static <T extends Identifiable> Function<T, String> fn() {
        return FN;
    }

    public IdRegistry(String name, Collection<T> instances) {
        this(name, instances, true);
    }

    public IdRegistry(String name, Collection<T> instances, boolean caseSensitive) {
        super(name, "id", Assert.notEmpty(instances, (String)"Collection of Identifiable instances may not be null or empty."), IdRegistry.fn(), caseSensitive);
    }
}

