/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.iam;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;
import org.gcube.com.fasterxml.jackson.annotation.JsonSetter;
import org.gcube.common.keycloak.model.AccessToken;

@JsonIgnoreProperties(ignoreUnknown=true)
public class D4ScienceJWTObject
extends AccessToken {
    protected static final List<String> MINIMAL_ROLES = Arrays.asList("Member");
    private String clientId;
    @JsonProperty(value="name")
    private String clientName;
    @JsonProperty(value="contact_person")
    private String contactPerson;
    @JsonProperty(value="contact_organisation")
    private String contactOrganisation;
    private static final String INTERNAL_CLIENT_ORGANISATION_NAME = "D4Science";

    public String getUsername() {
        return super.getPreferredUsername();
    }

    public List<String> getContextRoles() {
        AccessToken.Access access;
        String currentContext = this.getRawContext();
        if (currentContext != null && this.getResourceAccess() != null && (access = (AccessToken.Access)this.getResourceAccess().get(currentContext)) != null && access.getRoles() != null) {
            return new ArrayList<String>(access.getRoles());
        }
        return MINIMAL_ROLES;
    }

    public List<String> getRoles() {
        return this.getContextRoles();
    }

    public List<String> getRealmRoles() {
        if (this.getRealmAccess() != null && this.getRealmAccess().getRoles() != null) {
            return new ArrayList<String>(this.getRealmAccess().getRoles());
        }
        return Collections.emptyList();
    }

    public String getRawContext() {
        String[] audience = this.getAudience();
        if (audience != null && audience.length > 0) {
            return audience[0];
        }
        return null;
    }

    public String getContext() {
        String raw_audience = this.getRawContext();
        if (raw_audience == null) {
            return null;
        }
        try {
            return URLDecoder.decode(raw_audience, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            return raw_audience;
        }
    }

    @JsonIgnore
    public boolean isExternalService() {
        return this.contactOrganisation != null && this.contactOrganisation.equals(INTERNAL_CLIENT_ORGANISATION_NAME);
    }

    @JsonIgnore
    public boolean isApplication() {
        return this.clientId != null;
    }

    @JsonSetter(value="client_id")
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @JsonSetter(value="clientId")
    private void setMediaAsset(String clientId) {
        if (this.clientId == null) {
            this.setClientId(clientId);
        }
    }

    public String getClientName() {
        if (this.clientName != null) {
            return this.clientName;
        }
        return super.getName();
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getContactPerson() {
        return this.contactPerson;
    }

    public void setContactPerson(String contactPerson) {
        this.contactPerson = contactPerson;
    }

    public String getContactOrganisation() {
        return this.contactOrganisation;
    }

    public void setContactOrganisation(String contactOrganisation) {
        this.contactOrganisation = contactOrganisation;
    }
}

