/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.health;

import java.util.List;
import java.util.TimerTask;
import java.util.stream.Collectors;
import org.gcube.common.health.api.HealthCheck;
import org.gcube.common.health.api.Status;
import org.gcube.common.health.api.response.HealthCheckResponse;
import org.gcube.smartgears.health.HealthManager;
import org.gcube.smartgears.health.HealthResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthTask
extends TimerTask {
    private static final Logger log = LoggerFactory.getLogger(HealthTask.class);
    private HealthResponse response;
    private HealthManager healthManager;

    public HealthTask(HealthManager healthManager) {
        this.healthManager = healthManager;
    }

    @Override
    public void run() {
        List<HealthCheck> checks = this.healthManager.getChecks();
        List<HealthCheckResponse> responses = checks.stream().map(c -> this.wrap((HealthCheck)c)).collect(Collectors.toList());
        Status totalStatus = responses.stream().anyMatch(r -> r.getStatus().equals((Object)Status.DOWN)) ? Status.DOWN : Status.UP;
        this.response = new HealthResponse(totalStatus, responses);
        log.trace("health task executed with total status {}", (Object)totalStatus);
    }

    public HealthResponse getResponse() {
        return this.response;
    }

    private HealthCheckResponse wrap(HealthCheck check) {
        try {
            return check.check();
        }
        catch (Throwable t) {
            return HealthCheckResponse.builder((String)check.getName()).down().error(t.getMessage()).build();
        }
    }
}

