/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl;

import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.gcube.io.jsonwebtoken.ClaimsMutator;
import org.gcube.io.jsonwebtoken.impl.AbstractAudienceCollection;
import org.gcube.io.jsonwebtoken.impl.DefaultClaims;
import org.gcube.io.jsonwebtoken.impl.ParameterMap;
import org.gcube.io.jsonwebtoken.impl.lang.DelegatingMapMutator;
import org.gcube.io.jsonwebtoken.impl.lang.Parameter;
import org.gcube.io.jsonwebtoken.impl.lang.Parameters;
import org.gcube.io.jsonwebtoken.lang.Collections;
import org.gcube.io.jsonwebtoken.lang.MapMutator;
import org.gcube.io.jsonwebtoken.lang.Strings;

public class DelegatingClaimsMutator<T extends MapMutator<String, Object, T> & ClaimsMutator<T>>
extends DelegatingMapMutator<String, Object, ParameterMap, T>
implements ClaimsMutator<T> {
    private static final Parameter<String> AUDIENCE_STRING = Parameters.string(DefaultClaims.AUDIENCE.getId(), DefaultClaims.AUDIENCE.getName());

    protected DelegatingClaimsMutator() {
        super(new ParameterMap(DefaultClaims.PARAMS));
    }

    @Override
    <F> T put(Parameter<F> param, F value) {
        ((ParameterMap)this.DELEGATE).put(param, value);
        return this.self();
    }

    @Override
    public Object put(String key, Object value) {
        if (AUDIENCE_STRING.getId().equals(key)) {
            if (value instanceof String) {
                Object existing = this.get(key);
                this.audience().single((String)value);
                return existing;
            }
            this.getAudience();
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        if (m == null) {
            return;
        }
        for (Map.Entry<String, ?> entry : m.entrySet()) {
            String s = entry.getKey();
            this.put(s, entry.getValue());
        }
    }

    <F> F get(Parameter<F> param) {
        return ((ParameterMap)this.DELEGATE).get(param);
    }

    public T setIssuer(String iss) {
        return this.issuer(iss);
    }

    public T issuer(String iss) {
        return this.put((Parameter)DefaultClaims.ISSUER, (Object)iss);
    }

    public T setSubject(String sub) {
        return this.subject(sub);
    }

    public T subject(String sub) {
        return this.put((Parameter)DefaultClaims.SUBJECT, (Object)sub);
    }

    public T setAudience(String aud) {
        return (T)((MapMutator)this.audience().single(aud));
    }

    private Set<String> getAudience() {
        if (!((Parameter)((ParameterMap)this.DELEGATE).PARAMS.get((Object)AUDIENCE_STRING.getId())).supports(Collections.emptySet())) {
            String existing = this.get(AUDIENCE_STRING);
            this.remove(AUDIENCE_STRING.getId());
            this.setDelegate(((ParameterMap)this.DELEGATE).replace(DefaultClaims.AUDIENCE));
            this.put((Parameter)DefaultClaims.AUDIENCE, (Object)Collections.setOf((Object[])new String[]{existing}));
        }
        return this.get(DefaultClaims.AUDIENCE);
    }

    private T audienceSingle(String aud) {
        if (!Strings.hasText((String)aud)) {
            return this.put((Parameter)DefaultClaims.AUDIENCE, (Object)null);
        }
        this.remove(AUDIENCE_STRING.getId());
        this.setDelegate(((ParameterMap)this.DELEGATE).replace(AUDIENCE_STRING));
        return this.put((Parameter)AUDIENCE_STRING, (Object)aud);
    }

    public ClaimsMutator.AudienceCollection<T> audience() {
        return new AbstractAudienceCollection<T>((MapMutator)this.self(), this.getAudience()){

            public T single(String audience) {
                return DelegatingClaimsMutator.this.audienceSingle(audience);
            }

            @Override
            protected void changed() {
                DelegatingClaimsMutator.this.put(DefaultClaims.AUDIENCE, Collections.asSet(this.getCollection()));
            }
        };
    }

    public T setExpiration(Date exp) {
        return this.expiration(exp);
    }

    public T expiration(Date exp) {
        return this.put((Parameter)DefaultClaims.EXPIRATION, (Object)exp);
    }

    public T setNotBefore(Date nbf) {
        return this.notBefore(nbf);
    }

    public T notBefore(Date nbf) {
        return this.put((Parameter)DefaultClaims.NOT_BEFORE, (Object)nbf);
    }

    public T setIssuedAt(Date iat) {
        return this.issuedAt(iat);
    }

    public T issuedAt(Date iat) {
        return this.put((Parameter)DefaultClaims.ISSUED_AT, (Object)iat);
    }

    public T setId(String jti) {
        return this.id(jti);
    }

    public T id(String jti) {
        return this.put((Parameter)DefaultClaims.JTI, (Object)jti);
    }
}

