/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.contexts.impl.entities;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.annotation.JsonGetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonInclude;
import org.gcube.com.fasterxml.jackson.annotation.JsonSetter;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.contexts.impl.entities.ContextImpl;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.model.reference.properties.Event;
import org.gcube.resourcemanagement.contexts.impl.properties.BasicInformation;

@JsonTypeName(value="Context")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GCubeContext
extends ContextImpl {
    private static final long serialVersionUID = -8929392680534884169L;
    public static final String EVENTS_PROPERTY = "events";
    public static final String INFORMATION_PROPERTY = "information";
    public static final String KEY_PROPERTY = "key";
    public static final String AVAILABLE_AT_PROPERTY = "availableAt";
    protected SortedSet<Event> events;
    protected BasicInformation information;
    protected String key;
    protected List<String> availableAt;

    public GCubeContext(Context c) {
        this.uuid = c.getID();
        this.metadata = c.getMetadata();
        this.name = c.getName();
        this.parent = c.getParent();
        this.children = c.getChildren();
        this.state = c.getState();
        this.additionalProperties = new HashMap();
        Map ap = c.getAdditionalProperties();
        block12: for (String key : ap.keySet()) {
            Object obj = ap.get(key);
            switch (key) {
                case "events": {
                    SortedSet events = (SortedSet)obj;
                    this.setEvents(events);
                    continue block12;
                }
                case "key": {
                    this.setKey((String)obj);
                    continue block12;
                }
                case "information": {
                    this.setInformation((BasicInformation)obj);
                    continue block12;
                }
                case "availableAt": {
                    List availableAt = (List)obj;
                    this.setAvailableAt(availableAt);
                    continue block12;
                }
            }
            this.additionalProperties.put(key, obj);
        }
    }

    protected GCubeContext() {
    }

    public GCubeContext(UUID uuid) {
        this(null, uuid);
    }

    public GCubeContext(String name) {
        this(name, null);
    }

    public GCubeContext(String name, UUID uuid) {
        super(name, uuid);
    }

    @JsonGetter(value="events")
    public SortedSet<Event> getEvents() {
        return this.events;
    }

    @JsonSetter(value="events")
    public void setEvents(SortedSet<Event> events) {
        this.events = events;
    }

    @JsonIgnore
    public void addEvent(Event event) {
        if (this.events == null) {
            this.events = new TreeSet<Event>();
        }
        this.events.add(event);
    }

    @JsonGetter(value="information")
    public BasicInformation getInformation() {
        return this.information;
    }

    @JsonSetter(value="information")
    public void setInformation(BasicInformation information) {
        this.information = information;
    }

    @JsonGetter(value="key")
    public String getKey() {
        return this.key;
    }

    @JsonSetter(value="key")
    public void setKey(String key) {
        this.key = key;
    }

    @JsonGetter(value="availableAt")
    public List<String> getAvailableAt() {
        return this.availableAt;
    }

    @JsonSetter(value="availableAt")
    public void setAvailableAt(List<String> availableAt) {
        this.availableAt = availableAt;
    }
}

