/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.base.reference;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.gcube.informationsystem.base.impl.entities.EntityElementImpl;
import org.gcube.informationsystem.base.impl.properties.PropertyElementImpl;
import org.gcube.informationsystem.base.impl.relations.RelationElementImpl;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.base.reference.properties.PropertyElement;
import org.gcube.informationsystem.base.reference.relations.RelationElement;
import org.gcube.informationsystem.contexts.impl.entities.ContextImpl;
import org.gcube.informationsystem.contexts.impl.relations.IsParentOfImpl;
import org.gcube.informationsystem.contexts.reference.entities.Context;
import org.gcube.informationsystem.contexts.reference.relations.IsParentOf;
import org.gcube.informationsystem.model.impl.entities.DummyFacet;
import org.gcube.informationsystem.model.impl.entities.DummyResource;
import org.gcube.informationsystem.model.impl.entities.EntityImpl;
import org.gcube.informationsystem.model.impl.entities.FacetImpl;
import org.gcube.informationsystem.model.impl.entities.ResourceImpl;
import org.gcube.informationsystem.model.impl.properties.PropertyImpl;
import org.gcube.informationsystem.model.impl.relations.ConsistsOfImpl;
import org.gcube.informationsystem.model.impl.relations.IsRelatedToImpl;
import org.gcube.informationsystem.model.impl.relations.RelationImpl;
import org.gcube.informationsystem.model.reference.entities.Entity;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Property;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.model.reference.relations.Relation;
import org.gcube.informationsystem.queries.templates.impl.entities.QueryTemplateImpl;
import org.gcube.informationsystem.queries.templates.impl.properties.TemplateVariableImpl;
import org.gcube.informationsystem.queries.templates.reference.entities.QueryTemplate;
import org.gcube.informationsystem.queries.templates.reference.properties.TemplateVariable;
import org.gcube.informationsystem.types.impl.entities.EntityTypeImpl;
import org.gcube.informationsystem.types.impl.properties.PropertyDefinitionImpl;
import org.gcube.informationsystem.types.impl.properties.PropertyTypeImpl;
import org.gcube.informationsystem.types.impl.relations.RelationTypeImpl;
import org.gcube.informationsystem.types.reference.entities.EntityType;
import org.gcube.informationsystem.types.reference.properties.PropertyDefinition;
import org.gcube.informationsystem.types.reference.properties.PropertyType;
import org.gcube.informationsystem.types.reference.relations.RelationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AccessType
extends Enum<AccessType> {
    public static final /* enum */ AccessType PROPERTY_ELEMENT;
    public static final /* enum */ AccessType PROPERTY_DEFINITION;
    public static final /* enum */ AccessType PROPERTY_TYPE;
    public static final /* enum */ AccessType TEMPLATE_VARIABLE;
    public static final /* enum */ AccessType PROPERTY;
    public static final /* enum */ AccessType ENTITY_ELEMENT;
    public static final /* enum */ AccessType ENTITY_TYPE;
    public static final /* enum */ AccessType QUERY_TEMPLATE;
    public static final /* enum */ AccessType CONTEXT;
    public static final /* enum */ AccessType ENTITY;
    public static final /* enum */ AccessType RESOURCE;
    public static final /* enum */ AccessType FACET;
    public static final /* enum */ AccessType RELATION_ELEMENT;
    public static final /* enum */ AccessType RELATION_TYPE;
    public static final /* enum */ AccessType IS_PARENT_OF;
    public static final /* enum */ AccessType RELATION;
    public static final /* enum */ AccessType IS_RELATED_TO;
    public static final /* enum */ AccessType CONSISTS_OF;
    private static Logger logger;
    private static AccessType[] modelTypes;
    private static AccessType[] erTypes;
    private static Set<String> names;
    private final Class<? extends Element> clz;
    private final Class<? extends Element> implementationClass;
    private final Class<? extends Element> dummyImplementationClass;
    private final String name;
    private final String lowerCaseFirstCharacter;
    private static final /* synthetic */ AccessType[] $VALUES;

    public static AccessType[] values() {
        return (AccessType[])$VALUES.clone();
    }

    public static AccessType valueOf(String name) {
        return Enum.valueOf(AccessType.class, name);
    }

    private <ISM extends Element, ISMC extends ISM, ISMD extends ISMC> AccessType(Class<ISM> clz, String name, Class<ISMC> implementationClass, Class<ISMD> dummyImplementationClass) {
        this.clz = clz;
        this.implementationClass = implementationClass;
        this.dummyImplementationClass = dummyImplementationClass;
        this.name = name;
        this.lowerCaseFirstCharacter = name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public <ISM extends Element> Class<ISM> getTypeClass() {
        return this.clz;
    }

    public <ISM extends Element, ISMC extends ISM> Class<ISMC> getImplementationClass() {
        return this.implementationClass;
    }

    public <ISM extends Element, ISMC extends ISM, ISMD extends ISMC> Class<ISMD> getDummyImplementationClass() {
        return this.dummyImplementationClass;
    }

    public String getName() {
        return this.name;
    }

    public String lowerCaseFirstCharacter() {
        return this.lowerCaseFirstCharacter;
    }

    public String toString() {
        return this.name;
    }

    public static Set<String> names() {
        return names;
    }

    public static AccessType getAccessType(String typeName) {
        AccessType[] accessTypes;
        for (AccessType accessType : accessTypes = AccessType.values()) {
            String name = accessType.getName();
            if (name.compareTo(typeName) != 0) continue;
            return accessType;
        }
        return null;
    }

    public static AccessType getAccessType(Class<?> clz) {
        AccessType[] accessTypes;
        AccessType ret = null;
        for (AccessType accessType : accessTypes = AccessType.values()) {
            Class typeClass = accessType.getTypeClass();
            if (!typeClass.isAssignableFrom(clz) || ret != null && !ret.getTypeClass().isAssignableFrom(typeClass)) continue;
            ret = accessType;
        }
        if (ret != null) {
            return ret;
        }
        String error = "The provided class %s does not belong to any of defined AccessTypes %s".formatted(clz.getSimpleName(), Arrays.toString((Object[])accessTypes));
        logger.trace(error);
        throw new RuntimeException(error);
    }

    public static AccessType[] getModelTypes() {
        return modelTypes;
    }

    public static AccessType[] getERTypes() {
        return erTypes;
    }

    private static /* synthetic */ AccessType[] $values() {
        return new AccessType[]{PROPERTY_ELEMENT, PROPERTY_DEFINITION, PROPERTY_TYPE, TEMPLATE_VARIABLE, PROPERTY, ENTITY_ELEMENT, ENTITY_TYPE, QUERY_TEMPLATE, CONTEXT, ENTITY, RESOURCE, FACET, RELATION_ELEMENT, RELATION_TYPE, IS_PARENT_OF, RELATION, IS_RELATED_TO, CONSISTS_OF};
    }

    static {
        AccessType[] accessTypes;
        PROPERTY_ELEMENT = new AccessType(PropertyElement.class, "PropertyElement", PropertyElementImpl.class, null);
        PROPERTY_DEFINITION = new AccessType(PropertyDefinition.class, "PropertyDefinition", PropertyDefinitionImpl.class, null);
        PROPERTY_TYPE = new AccessType(PropertyType.class, "PropertyType", PropertyTypeImpl.class, null);
        TEMPLATE_VARIABLE = new AccessType(TemplateVariable.class, "TemplateVariable", TemplateVariableImpl.class, null);
        PROPERTY = new AccessType(Property.class, "Property", PropertyImpl.class, null);
        ENTITY_ELEMENT = new AccessType(EntityElement.class, "EntityElement", EntityElementImpl.class, null);
        ENTITY_TYPE = new AccessType(EntityType.class, "EntityType", EntityTypeImpl.class, null);
        QUERY_TEMPLATE = new AccessType(QueryTemplate.class, "QueryTemplate", QueryTemplateImpl.class, null);
        CONTEXT = new AccessType(Context.class, "Context", ContextImpl.class, null);
        ENTITY = new AccessType(Entity.class, "Entity", EntityImpl.class, null);
        RESOURCE = new AccessType(Resource.class, "Resource", ResourceImpl.class, DummyResource.class);
        FACET = new AccessType(Facet.class, "Facet", FacetImpl.class, DummyFacet.class);
        RELATION_ELEMENT = new AccessType(RelationElement.class, "RelationElement", RelationElementImpl.class, null);
        RELATION_TYPE = new AccessType(RelationType.class, "RelationType", RelationTypeImpl.class, null);
        IS_PARENT_OF = new AccessType(IsParentOf.class, "IsParentOf", IsParentOfImpl.class, null);
        RELATION = new AccessType(Relation.class, "Relation", RelationImpl.class, null);
        IS_RELATED_TO = new AccessType(IsRelatedTo.class, "IsRelatedTo", IsRelatedToImpl.class, IsRelatedToImpl.class);
        CONSISTS_OF = new AccessType(ConsistsOf.class, "ConsistsOf", ConsistsOfImpl.class, null);
        $VALUES = AccessType.$values();
        logger = LoggerFactory.getLogger(AccessType.class);
        names = new HashSet<String>();
        for (AccessType accessType : accessTypes = AccessType.values()) {
            String name = accessType.getName();
            names.add(name);
        }
        modelTypes = new AccessType[]{PROPERTY, RESOURCE, FACET, IS_RELATED_TO, CONSISTS_OF};
        erTypes = new AccessType[]{RESOURCE, FACET, IS_RELATED_TO, CONSISTS_OF};
    }
}

