/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.request;

import java.util.Objects;
import java.util.Set;
import org.gcube.common.security.ContextBean;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.smartgears.configuration.Mode;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.RequestEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.ResponseEvent;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.gcube.smartgears.security.secrets.SecretFactory;
import org.gcube.smartgears.security.secrets.exceptions.SecretNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestValidator
extends RequestHandler {
    private static Logger log = LoggerFactory.getLogger(RequestValidator.class);
    private ApplicationContext appContext;

    @Override
    public String getName() {
        return "request-validation";
    }

    @Override
    public void handleRequest(RequestEvent call) {
        log.trace("executing request validator ON REQUEST");
        this.appContext = (ApplicationContext)call.context();
        SecretManagerProvider.set((Secret)this.getSecret(call));
        this.validateAgainstLifecycle(call);
        this.rejectUnauthorizedCalls(call);
        if (this.appContext.container().configuration().mode() != Mode.offline) {
            this.validateScopeCall();
        }
    }

    @Override
    public void handleResponse(ResponseEvent e) {
        log.debug("resetting all the Thread local for this call.");
        SecretManagerProvider.reset();
    }

    private void validateAgainstLifecycle(RequestEvent call) {
        switch ((ApplicationState)this.appContext.lifecycle().state()) {
            case stopped: {
                RequestError.application_unavailable_error.fire();
                break;
            }
            case failed: {
                RequestError.application_failed_error.fire();
                break;
            }
        }
    }

    private void validateScopeCall() {
        String context = SecretManagerProvider.get().getContext();
        if (context == null) {
            log.warn("rejecting unscoped call to {}", (Object)this.appContext.name());
            RequestError.invalid_request_error.fire("call is unscoped");
        }
        ContextBean bean = new ContextBean(context);
        ContainerConfiguration conf = this.appContext.container().configuration();
        Set allowedContexts = this.appContext.authorizationProvider().getContexts();
        if (!(allowedContexts.contains(context) || conf.authorizeChildrenContext() && bean.is(ContextBean.Type.VRE) && allowedContexts.contains(bean.enclosingScope().toString()))) {
            log.warn("rejecting call to {} in invalid context {}, allowed context are {}", new Object[]{this.appContext.name(), context, allowedContexts});
            RequestError.invalid_request_error.fire(this.appContext.name() + " cannot be called in scope " + context);
        }
    }

    private void rejectUnauthorizedCalls(RequestEvent call) {
        Secret secret = SecretManagerProvider.get();
        if (secret == null) {
            log.warn("rejecting call to {}, authorization required", (Object)this.appContext.name());
            RequestError.request_not_authorized_error.fire(this.appContext.name() + ": authorization required");
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    private Secret getSecret(RequestEvent call) {
        Object secret = null;
        for (SecretFactory<? extends Secret> factory : ((ApplicationContext)call.context()).allowedSecretFactories()) {
            try {
                secret = factory.create(call.request());
                break;
            }
            catch (SecretNotFoundException e) {
                log.info("authorization for secret {} not found", (Object)factory.getSecretClass().getName());
            }
            catch (Throwable t) {
                log.warn("generic error creating secret {}", (Object)factory.getSecretClass().getName(), (Object)t);
            }
        }
        if (Objects.isNull(secret)) {
            RequestError.request_not_authorized_error.fire("call not authorized");
        }
        if (!secret.isValid()) {
            RequestError.request_not_authorized_error.fire("authorization with secret " + secret.getClass().getSimpleName() + ": token not valid ");
        }
        if (((ApplicationContext)call.context()).container().configuration().checkTokenExpiration() && secret.isExpired()) {
            RequestError.request_not_authorized_error.fire("authorization with secret " + secret.getClass().getSimpleName() + ": token expired ");
        }
        return secret;
    }
}

