/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.lang;

import org.gcube.io.jsonwebtoken.impl.lang.Converter;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.lang.Strings;

public final class CompactMediaTypeIdConverter
implements Converter<String, Object> {
    public static final Converter<String, Object> INSTANCE = new CompactMediaTypeIdConverter();
    private static final char FORWARD_SLASH = '/';
    private static final String APP_MEDIA_TYPE_PREFIX = "application/";

    static String compactIfPossible(String cty) {
        Assert.hasText((CharSequence)cty, (String)"Value cannot be null or empty.");
        if (Strings.startsWithIgnoreCase((String)cty, (String)APP_MEDIA_TYPE_PREFIX)) {
            for (int i = cty.length() - 1; i >= APP_MEDIA_TYPE_PREFIX.length(); --i) {
                char c = cty.charAt(i);
                if (c != '/') continue;
                return cty;
            }
            return cty.substring(APP_MEDIA_TYPE_PREFIX.length());
        }
        return cty;
    }

    @Override
    public Object applyTo(String s) {
        return CompactMediaTypeIdConverter.compactIfPossible(s);
    }

    @Override
    public String applyFrom(Object o) {
        Assert.notNull((Object)o, (String)"Value cannot be null.");
        String s = (String)Assert.isInstanceOf(String.class, (Object)o, (String)"Value must be a string.");
        if (s.indexOf(47) < 0) {
            s = APP_MEDIA_TYPE_PREFIX + s;
        }
        return s;
    }
}

