/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.security;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.gcube.io.jsonwebtoken.JweHeader;
import org.gcube.io.jsonwebtoken.impl.DefaultJweHeader;
import org.gcube.io.jsonwebtoken.impl.lang.Bytes;
import org.gcube.io.jsonwebtoken.impl.lang.CheckedFunction;
import org.gcube.io.jsonwebtoken.impl.lang.ParameterReadable;
import org.gcube.io.jsonwebtoken.impl.lang.RequiredParameterReader;
import org.gcube.io.jsonwebtoken.impl.security.AesAlgorithm;
import org.gcube.io.jsonwebtoken.impl.security.DefaultKeyResult;
import org.gcube.io.jsonwebtoken.io.Encoders;
import org.gcube.io.jsonwebtoken.lang.Assert;
import org.gcube.io.jsonwebtoken.security.DecryptionKeyRequest;
import org.gcube.io.jsonwebtoken.security.KeyRequest;
import org.gcube.io.jsonwebtoken.security.KeyResult;
import org.gcube.io.jsonwebtoken.security.Request;
import org.gcube.io.jsonwebtoken.security.SecretKeyAlgorithm;
import org.gcube.io.jsonwebtoken.security.SecurityException;

public class AesGcmKeyAlgorithm
extends AesAlgorithm
implements SecretKeyAlgorithm {
    public static final String TRANSFORMATION = "AES/GCM/NoPadding";

    public AesGcmKeyAlgorithm(int keyLen) {
        super("A" + keyLen + "GCMKW", TRANSFORMATION, keyLen);
    }

    public KeyResult getEncryptionKey(KeyRequest<SecretKey> request) throws SecurityException {
        Assert.notNull(request, (String)"request cannot be null.");
        JweHeader header = (JweHeader)Assert.notNull((Object)request.getHeader(), (String)"Request JweHeader cannot be null.");
        final SecretKey kek = this.assertKey((SecretKey)request.getPayload());
        final SecretKey cek = this.generateCek(request);
        byte[] iv = this.ensureInitializationVector((Request<?>)request);
        final AlgorithmParameterSpec ivSpec = this.getIvSpec(iv);
        byte[] taggedCiphertext = this.jca((Request<?>)request).withCipher(new CheckedFunction<Cipher, byte[]>(){

            @Override
            public byte[] apply(Cipher cipher) throws Exception {
                cipher.init(3, (Key)kek, ivSpec);
                return cipher.wrap(cek);
            }
        });
        int tagByteLength = this.tagBitLength / 8;
        int ciphertextLength = taggedCiphertext.length - tagByteLength;
        byte[] ciphertext = new byte[ciphertextLength];
        System.arraycopy(taggedCiphertext, 0, ciphertext, 0, ciphertextLength);
        byte[] tag = new byte[tagByteLength];
        System.arraycopy(taggedCiphertext, ciphertextLength, tag, 0, tagByteLength);
        String encodedIv = (String)Encoders.BASE64URL.encode((Object)iv);
        String encodedTag = (String)Encoders.BASE64URL.encode((Object)tag);
        header.put((Object)DefaultJweHeader.IV.getId(), (Object)encodedIv);
        header.put((Object)DefaultJweHeader.TAG.getId(), (Object)encodedTag);
        return new DefaultKeyResult(cek, ciphertext);
    }

    public SecretKey getDecryptionKey(DecryptionKeyRequest<SecretKey> request) throws SecurityException {
        Assert.notNull(request, (String)"request cannot be null.");
        final SecretKey kek = this.assertKey((SecretKey)request.getKey());
        byte[] cekBytes = Assert.notEmpty((byte[])((byte[])request.getPayload()), (String)"Decryption request content (ciphertext) cannot be null or empty.");
        JweHeader header = (JweHeader)Assert.notNull((Object)request.getHeader(), (String)"Request JweHeader cannot be null.");
        ParameterReadable frHeader = (ParameterReadable)Assert.isInstanceOf(ParameterReadable.class, (Object)header, (String)"Header must implement ParameterReadable.");
        RequiredParameterReader reader = new RequiredParameterReader(frHeader);
        byte[] tag = reader.get(DefaultJweHeader.TAG);
        byte[] iv = reader.get(DefaultJweHeader.IV);
        final AlgorithmParameterSpec ivSpec = this.getIvSpec(iv);
        final byte[] taggedCiphertext = Bytes.concat(cekBytes, tag);
        return this.jca((Request<?>)request).withCipher(new CheckedFunction<Cipher, SecretKey>(){

            @Override
            public SecretKey apply(Cipher cipher) throws Exception {
                cipher.init(4, (Key)kek, ivSpec);
                Key key = cipher.unwrap(taggedCiphertext, "AES", 3);
                Assert.state((boolean)(key instanceof SecretKey), (String)"cipher.unwrap must produce a SecretKey instance.");
                return (SecretKey)key;
            }
        });
    }
}

