/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.provider;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gcube.common.events.Hub;
import org.gcube.common.events.impl.DefaultHub;
import org.gcube.common.security.credentials.Credentials;
import org.gcube.common.security.factories.AuthorizationProvider;
import org.gcube.common.security.factories.AuthorizationProviderFactory;
import org.gcube.smartgears.configuration.SmartgearsConfiguration;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.application.ApplicationConfigurationBinder;
import org.gcube.smartgears.configuration.application.ApplicationHandlers;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.configuration.container.ContainerConfigurationBinder;
import org.gcube.smartgears.context.Properties;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.application.DefaultApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.context.container.DefaultContainerContext;
import org.gcube.smartgears.extensions.ApplicationExtension;
import org.gcube.smartgears.extensions.resource.RemoteResource;
import org.gcube.smartgears.handlers.container.ContainerHandler;
import org.gcube.smartgears.lifecycle.application.ApplicationLifecycle;
import org.gcube.smartgears.lifecycle.container.ContainerLifecycle;
import org.gcube.smartgears.provider.Provider;
import org.gcube.smartgears.publishing.Publisher;
import org.gcube.smartgears.publishing.SmartgearsProfilePublisher;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProvider
implements Provider {
    private static Logger log = LoggerFactory.getLogger(Provider.class);
    private ContainerContext containerContext;
    private File configFile = null;
    List<Publisher> publishers;

    protected DefaultProvider(File configFile) {
        this.configFile = configFile;
    }

    protected DefaultProvider() {
    }

    @Override
    public ContainerContext containerContext() {
        if (this.containerContext == null) {
            ContainerConfiguration configuration = this.containerConfiguration();
            DefaultHub hub = new DefaultHub();
            ContainerLifecycle lifecycle = new ContainerLifecycle((Hub)hub);
            AuthorizationProviderFactory<?> authfactory = configuration.authorizationConfiguration().getAuthProviderFactory();
            Credentials credentials = configuration.authorizationConfiguration().getCredentials();
            AuthorizationProvider authProvider = authfactory.connect(credentials);
            this.containerContext = new DefaultContainerContext(configuration, (Hub)hub, lifecycle, authProvider, new Properties());
        }
        return this.containerContext;
    }

    @Override
    public List<ContainerHandler> containerHandlers() {
        try {
            ContainerConfigurationBinder binder = new ContainerConfigurationBinder();
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            if (currentClassLoader.getParent() != null && !currentClassLoader.getParent().equals(ClassLoader.getSystemClassLoader())) {
                log.trace("probably i'm in a webapp classloader");
                currentClassLoader = currentClassLoader.getParent();
            }
            List<ContainerHandler> defaultHandlers = binder.bindHandlers(currentClassLoader);
            return defaultHandlers;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("cannot install container handlers (see cause) ", e);
        }
    }

    @Override
    public ApplicationContext contextFor(ContainerContext context, ServletContext application) {
        ApplicationConfiguration embedded = this.configurationFor(application);
        if (embedded == null) {
            throw new AssertionError((Object)("application @ " + application.getContextPath() + " is not distributed with /WEB-INF/application.yaml and there is no external configuration for it in container.ini"));
        }
        DefaultHub hub = new DefaultHub();
        ApplicationLifecycle lifecycle = new ApplicationLifecycle((Hub)hub, embedded.name());
        return new DefaultApplicationContext(context, application, embedded, (Hub)hub, lifecycle, new Properties());
    }

    @Override
    public ApplicationHandlers handlersFor(ApplicationContext context) {
        try {
            ApplicationConfigurationBinder binder = new ApplicationConfigurationBinder();
            ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
            if (currentClassLoader.getParent() != null && !currentClassLoader.getParent().equals(ClassLoader.getSystemClassLoader())) {
                log.trace("probably i'm in a webapp classloader");
                currentClassLoader = currentClassLoader.getParent();
            }
            ApplicationHandlers defaultHandlers = binder.bindHandlers(currentClassLoader);
            return defaultHandlers;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("cannot install handlers for application @ " + context.name() + " (see cause) ", e);
        }
    }

    @Override
    public List<ApplicationExtension> extensionsFor(ApplicationContext context) {
        return List.of(new RemoteResource());
    }

    private ApplicationConfiguration configurationFor(ServletContext application) {
        try {
            InputStream config = application.getResourceAsStream("/WEB-INF/application.yaml");
            if (config == null) {
                return null;
            }
            ApplicationConfigurationBinder binder = new ApplicationConfigurationBinder();
            return binder.load(config);
        }
        catch (RuntimeException e) {
            throw new RuntimeException("invalid configuration (see cause)", e);
        }
    }

    private ContainerConfiguration containerConfiguration() {
        ContainerConfiguration configuration;
        if (this.configFile == null) {
            String home = Utils.home();
            if (home == null) {
                throw new IllegalStateException("invalid node configuration: the environment variable GHN_HOME or the system property ghn.home must be defined");
            }
            File homeDir = new File(home);
            if (!(homeDir.exists() && homeDir.isDirectory() && homeDir.canRead() && homeDir.canWrite())) {
                throw new IllegalStateException("invalid node configuration: home " + home + " does not exist or is not a directory or cannot be accessed in read/write mode");
            }
            this.configFile = new File(homeDir, "container.ini");
            log.trace("reading container configuration @ {} ", (Object)this.configFile.getAbsolutePath());
        }
        if (!this.configFile.exists() || !this.configFile.canRead()) {
            throw new IllegalStateException("invalid node configuration: file " + this.configFile.getAbsolutePath() + " does not exist or cannot be accessed");
        }
        try (FileInputStream stream = new FileInputStream(this.configFile);){
            configuration = new ContainerConfigurationBinder().load(stream);
        }
        catch (Exception e) {
            throw new IllegalStateException("invalid node configuration: file " + this.configFile.getAbsolutePath() + " is invalid", e);
        }
        return configuration;
    }

    @Override
    public synchronized List<Publisher> publishers() {
        if (this.publishers == null) {
            Set annotatedPublishers;
            try (ScanResult result = new ClassGraph().enableClassInfo().enableAnnotationInfo().addClassLoader(Thread.currentThread().getContextClassLoader()).scan();){
                ClassInfoList classInfos = result.getClassesWithAnnotation(SmartgearsProfilePublisher.class.getName());
                annotatedPublishers = classInfos.stream().map(ClassInfo::loadClass).filter(c -> Publisher.class.isAssignableFrom((Class<?>)c)).collect(Collectors.toSet());
            }
            ArrayList<Publisher> foundPublishers = new ArrayList<Publisher>();
            for (Class annotatedPublisher : annotatedPublishers) {
                try {
                    foundPublishers.add((Publisher)annotatedPublisher.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    log.info("added class {} to publishers", (Object)annotatedPublisher);
                }
                catch (Throwable e) {
                    log.error("publisher class {} cannot be instantiated", (Object)annotatedPublisher.getCanonicalName(), (Object)e);
                }
            }
            this.publishers = foundPublishers;
            if (foundPublishers.isEmpty()) {
                log.warn("no publishers found in classloader");
            }
        }
        return this.publishers;
    }

    @Override
    public SmartgearsConfiguration smartgearsConfiguration() {
        ContainerConfigurationBinder binder = new ContainerConfigurationBinder();
        return binder.loadSmartgearsProperty();
    }
}

