/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.configuration.container;

import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.gcube.common.security.credentials.Credentials;
import org.gcube.common.security.factories.AuthorizationProviderFactory;
import org.gcube.smartgears.configuration.AuthorizationProviderConfiguration;
import org.gcube.smartgears.configuration.ComponentConfiguration;
import org.gcube.smartgears.configuration.ConfiguredWith;
import org.gcube.smartgears.configuration.PersistenceConfiguration;
import org.gcube.smartgears.configuration.ProxyAddress;
import org.gcube.smartgears.configuration.SmartgearsConfiguration;
import org.gcube.smartgears.configuration.container.BaseConfiguration;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.configuration.container.Site;
import org.gcube.smartgears.handlers.container.ContainerHandler;
import org.gcube.smartgears.handlers.container.lifecycle.AccountingManager;
import org.gcube.smartgears.handlers.container.lifecycle.ContainerProfileManager;
import org.gcube.smartgears.persistence.LocalWriter;
import org.gcube.smartgears.persistence.LocalWriterConfiguration;
import org.gcube.smartgears.security.defaults.DefaultAuthorizationProviderFactory;
import org.gcube.smartgears.utils.Utils;
import org.ini4j.Ini;
import org.ini4j.Profile;

public class ContainerConfigurationBinder {
    public ContainerConfiguration load(InputStream stream) {
        try {
            Profile.Section siteSection;
            Profile.Section propertiesSection;
            Ini configurator = new Ini(stream);
            ContainerConfiguration conf = new ContainerConfiguration();
            Profile.Section nodeSection = (Profile.Section)configurator.get((Object)"node");
            if (nodeSection != null) {
                BaseConfiguration nodeConf = new BaseConfiguration();
                nodeSection.to((Object)nodeConf);
                conf.setBaseConfiguration(nodeConf);
            }
            if ((propertiesSection = (Profile.Section)configurator.get((Object)"properties")) != null) {
                conf.setProperties(propertiesSection.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
            }
            if ((siteSection = (Profile.Section)configurator.get((Object)"site")) != null) {
                Site siteConf = new Site();
                siteSection.to((Object)siteConf);
                conf.setSite(siteConf);
            }
            this.initAuthorizationPart(configurator, conf);
            this.initPersistencePart(configurator, conf);
            this.initProxyPart(configurator, conf);
            String location = Utils.home() + "/state";
            File dir = new File(location);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            conf.setAccountingFallbackLocation(location);
            return conf;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void initProxyPart(Ini configurator, ContainerConfiguration conf) throws Exception {
        Profile.Section proxySection = (Profile.Section)configurator.get((Object)"proxy");
        if (proxySection != null) {
            ProxyAddress proxyConf = new ProxyAddress();
            proxySection.to((Object)proxyConf);
            conf.setProxy(proxyConf);
        }
    }

    private void initPersistencePart(Ini configurator, ContainerConfiguration conf) throws Exception {
        Profile.Section persistenceSection = (Profile.Section)configurator.get((Object)"persistence");
        if (persistenceSection != null) {
            String type = (String)persistenceSection.get((Object)"class");
            if (type == null) {
                throw new Exception("ini file error: type not found in \"persistence\" section");
            }
            Class<?> persistenceClass = null;
            try {
                persistenceClass = Class.forName(type);
            }
            catch (Exception e) {
                throw new Exception("ini file error: invalid persistence type in \"persistence\" section", e);
            }
            if (!persistenceClass.isAnnotationPresent(ConfiguredWith.class)) {
                throw new Exception("ini file error: invalid class type in \"persistence\" section,ConfiguredWith annotation not present");
            }
            Class<? extends ComponentConfiguration> writerConfClass = persistenceClass.getAnnotation(ConfiguredWith.class).value();
            ComponentConfiguration writerConfiguration = writerConfClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            persistenceSection.to((Object)writerConfiguration, ".");
            conf.setPersistenceConfiguration(new PersistenceConfiguration(persistenceClass, writerConfiguration));
        } else {
            String location = Utils.home() + "/state";
            File dir = new File(location);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            conf.setPersistenceConfiguration(new PersistenceConfiguration(LocalWriter.class, new LocalWriterConfiguration(location)));
        }
    }

    private void initAuthorizationPart(Ini configurator, ContainerConfiguration conf) throws Exception {
        Profile.Section authorizationSection = (Profile.Section)configurator.get((Object)"authorization");
        if (authorizationSection != null) {
            Credentials credentials;
            DefaultAuthorizationProviderFactory authProviderFactory;
            String provider = (String)authorizationSection.get((Object)"factory");
            if (provider != null) {
                try {
                    Object authProviderImpl = Class.forName(provider).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    authProviderFactory = (AuthorizationProviderFactory)AuthorizationProviderFactory.class.cast(authProviderImpl);
                }
                catch (Exception e) {
                    throw new Exception("ini file error: invalid provider type in \"authorization\" section", e);
                }
            } else {
                authProviderFactory = new DefaultAuthorizationProviderFactory();
            }
            authorizationSection.to((Object)authProviderFactory, "factory.");
            String type = (String)authorizationSection.get((Object)"credentials.class");
            if (type == null) {
                throw new Exception("ini file error: credentials type not found in \"authorization\" section");
            }
            try {
                Object credentialsImpl = Class.forName(type).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                credentials = (Credentials)Credentials.class.cast(credentialsImpl);
            }
            catch (Exception e) {
                throw new Exception("ini file error: invalid credentials type in \"authorization\" section", e);
            }
            authorizationSection.to((Object)credentials, "credentials.");
            conf.setAuthorizationProviderConfiguration(new AuthorizationProviderConfiguration(authProviderFactory, credentials));
        }
    }

    public List<ContainerHandler> bindHandlers(ClassLoader classloader) {
        LinkedList<ContainerHandler> handlers = new LinkedList<ContainerHandler>();
        handlers.add(new AccountingManager());
        handlers.add(new ContainerProfileManager());
        handlers.addAll(this.scanForContainerHadlers(classloader));
        return handlers;
    }

    private List<? extends ContainerHandler> scanForContainerHadlers(ClassLoader classloader) throws RuntimeException {
        return Collections.emptyList();
    }

    public SmartgearsConfiguration loadSmartgearsProperty() {
        try {
            Ini configurator = new Ini(this.getClass().getResourceAsStream("/META-INF/smartgears-config.ini"));
            String version = (String)((Profile.Section)configurator.get((Object)"smartgears")).get((Object)"version");
            return new SmartgearsConfiguration(version);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

