/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.gcore;

import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.common.GHNReference;
import org.gcube.common.resources.gcore.common.Platform;
import org.gcube.common.resources.gcore.utils.Group;

@XmlRootElement(name="Resource")
@XmlType(propOrder={"profile"})
public class ServiceEndpoint
extends Resource {
    @XmlElementRef
    private Profile profile;

    public ServiceEndpoint() {
        this.type(Resource.Type.ENDPOINT);
    }

    @Override
    public Profile profile() {
        return this.profile;
    }

    public Profile newProfile() {
        this.profile = new Profile();
        return this.profile;
    }

    @XmlRootElement(name="Profile")
    @XmlType(propOrder={"category", "name", "version", "description", "platform", "runtime", "accessPoints"})
    public static class Profile {
        @XmlElement(name="Category")
        private String category;
        @XmlElement(name="Name")
        private String name;
        @XmlElement(name="Version")
        private String version;
        @XmlElement(name="Description")
        private String description;
        @XmlElementRef
        private Platform platform;
        @XmlElementRef
        private Runtime runtime;
        @XmlElementRef
        private List<AccessPoint> accessPoints = new ArrayList<AccessPoint>();

        public String name() {
            return this.name;
        }

        public Profile name(String name) {
            this.name = name;
            return this;
        }

        public String description() {
            return this.description;
        }

        public Profile description(String description) {
            this.description = description;
            return this;
        }

        public String version() {
            return this.version;
        }

        public Profile version(String version) {
            this.version = version;
            return this;
        }

        public String category() {
            return this.category;
        }

        public Profile category(String category) {
            this.category = category;
            return this;
        }

        public Runtime runtime() {
            return this.runtime;
        }

        public Runtime newRuntime() {
            this.runtime = new Runtime();
            return this.runtime;
        }

        public Platform platform() {
            return this.platform;
        }

        public Platform newPlatform() {
            this.platform = new Platform();
            return this.platform;
        }

        public Group<AccessPoint> accessPoints() {
            return new Group<AccessPoint>(this.accessPoints, AccessPoint.class);
        }

        public String toString() {
            return "[name=" + this.name + ", description=" + this.description + ", version=" + this.version + ", category=" + this.category + ", runtime=" + this.runtime + ", platform=" + this.platform + ", accessPoints=" + this.accessPoints + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.accessPoints == null ? 0 : this.accessPoints.hashCode());
            result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.platform == null ? 0 : this.platform.hashCode());
            result = 31 * result + (this.runtime == null ? 0 : this.runtime.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Profile other = (Profile)obj;
            if (this.accessPoints == null ? other.accessPoints != null : !this.accessPoints.equals(other.accessPoints)) {
                return false;
            }
            if (this.category == null ? other.category != null : !this.category.equals(other.category)) {
                return false;
            }
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.platform == null ? other.platform != null : !this.platform.equals(other.platform)) {
                return false;
            }
            if (this.runtime == null ? other.runtime != null : !this.runtime.equals(other.runtime)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }
    }

    public static class PropertyValue {
        @XmlAttribute(name="encrypted")
        private boolean encrypted;
        @XmlValue
        private String value;

        public String toString() {
            return "[encrypted=" + this.encrypted + ", value=" + this.value + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.encrypted ? 1231 : 1237);
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyValue other = (PropertyValue)obj;
            if (this.encrypted != other.encrypted) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    @XmlRootElement(name="Property")
    @XmlType(propOrder={"name", "value"})
    public static class Property {
        @XmlElement(name="Name")
        private String name;
        @XmlElement(name="Value")
        private PropertyValue value = new PropertyValue();

        public String name() {
            return this.name;
        }

        public Property nameAndValue(String name, String value) {
            this.name = name;
            this.value.value = value;
            return this;
        }

        public boolean isEncrypted() {
            return this.value.encrypted;
        }

        public Property encrypted(boolean encrypted) {
            this.value.encrypted = encrypted;
            return this;
        }

        public String value() {
            return this.value.value;
        }

        public String toString() {
            return "Property [name=" + this.name + ", value=" + this.value + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Property other = (Property)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    @XmlRootElement(name="AccessPoint")
    @XmlType(propOrder={"description", "itfce", "accessData", "properties"})
    public static class AccessPoint {
        @XmlElement(name="Description")
        private String description;
        @XmlElementRef
        private Interface itfce = new Interface();
        @XmlElementRef
        private AccessData accessData;
        @XmlElementWrapper(name="Properties")
        @XmlElementRef
        private List<Property> properties = new ArrayList<Property>();

        void beforeMarshal(Marshaller marshaller) {
            if (this.properties != null && this.properties.isEmpty()) {
                this.properties = null;
            }
        }

        void afterMarshal(Marshaller marshaller) {
            if (this.properties == null) {
                this.properties = new ArrayList<Property>();
            }
        }

        public String description() {
            return this.description;
        }

        public AccessPoint description(String description) {
            this.description = description;
            return this;
        }

        public String username() {
            return this.accessData.username;
        }

        public String password() {
            return this.accessData.password;
        }

        public AccessPoint credentials(String password, String username) {
            this.accessData = new AccessData();
            this.accessData.password = password;
            this.accessData.username = username;
            return this;
        }

        public String name() {
            return this.itfce.endpoint().name();
        }

        public AccessPoint name(String address) {
            this.itfce.endpoint().name(address);
            return this;
        }

        public String address() {
            return this.itfce.endpoint().address();
        }

        public AccessPoint address(String address) {
            this.itfce.endpoint().address(address);
            return this;
        }

        public Group<Property> properties() {
            return new Group<Property>(this.properties, Property.class);
        }

        public Map<String, Property> propertyMap() {
            HashMap<String, Property> map = new HashMap<String, Property>();
            for (Property p : this.properties) {
                if (p.name() == null) continue;
                map.put(p.name(), p);
            }
            return map;
        }

        public String toString() {
            return "AccessPoint [description=" + this.description + ", accessData=" + this.accessData + ", interface=" + this.itfce + ", properties=" + this.properties + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.accessData == null ? 0 : this.accessData.hashCode());
            result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
            result = 31 * result + (this.itfce == null ? 0 : this.itfce.hashCode());
            result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccessPoint other = (AccessPoint)obj;
            if (this.accessData == null ? other.accessData != null : !this.accessData.equals(other.accessData)) {
                return false;
            }
            if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
                return false;
            }
            if (this.itfce == null ? other.itfce != null : !this.itfce.equals(other.itfce)) {
                return false;
            }
            return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
        }
    }

    @XmlRootElement(name="Interface")
    public static class Interface {
        @XmlElementRef
        private Endpoint endpoint = new Endpoint();

        public Endpoint endpoint() {
            return this.endpoint;
        }

        public String toString() {
            return "[endpoints=" + this.endpoint + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Interface other = (Interface)obj;
            return !(this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint));
        }
    }

    @XmlRootElement(name="Endpoint")
    public static class Endpoint {
        @XmlAttribute(name="EntryName")
        private String name;
        @XmlValue
        private String address;

        public String name() {
            return this.name;
        }

        public String address() {
            return this.address;
        }

        public void name(String name) {
            this.name = name;
        }

        public void address(String address) {
            this.address = address;
        }

        public String toString() {
            return "[name=" + this.name + ", address=" + this.address + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Endpoint other = (Endpoint)obj;
            if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
                return false;
            }
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }
    }

    @XmlRootElement(name="AccessData")
    @XmlType(propOrder={"username", "password"})
    static class AccessData {
        @XmlElement(name="Username")
        private String username;
        @XmlElement(name="Password")
        private String password;

        AccessData() {
        }

        public void set(String password, String username) {
            this.password = password;
            this.username = username;
        }

        public String toString() {
            return "[username=" + this.username + ", password=" + this.password + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
            result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AccessData other = (AccessData)obj;
            if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
                return false;
            }
            return !(this.username == null ? other.username != null : !this.username.equals(other.username));
        }
    }

    @XmlRootElement(name="RunTime")
    @XmlType(propOrder={"hostedOn", "ghn", "status"})
    public static class Runtime {
        @XmlElement(name="HostedOn")
        private String hostedOn;
        @XmlElement(name="GHN")
        private GHNReference ghn = new GHNReference();
        @XmlElement(name="Status")
        private String status;

        public String hostedOn() {
            return this.hostedOn;
        }

        public Runtime hostedOn(String hostedOn) {
            this.hostedOn = hostedOn;
            return this;
        }

        public String status() {
            return this.status;
        }

        public Runtime status(String status) {
            this.status = status;
            return this;
        }

        public String ghnId() {
            return this.ghn.id;
        }

        public Runtime ghnId(String id) {
            this.ghn.id = id;
            return this;
        }

        void beforeMarshal(Marshaller marshaller) {
            if (this.ghn != null && this.ghn.id == null) {
                this.ghn = null;
            }
        }

        void afterMarshal(Marshaller marshaller) {
            if (this.ghn == null) {
                this.ghn = new GHNReference();
            }
        }

        public String toString() {
            return "[hostedOn=" + this.hostedOn + ", status=" + this.status + ", ghn=" + this.ghn + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.ghn == null ? 0 : this.ghn.hashCode());
            result = 31 * result + (this.hostedOn == null ? 0 : this.hostedOn.hashCode());
            result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Runtime other = (Runtime)obj;
            if (this.ghn == null ? other.ghn != null : !this.ghn.equals(other.ghn)) {
                return false;
            }
            if (this.hostedOn == null ? other.hostedOn != null : !this.hostedOn.equals(other.hostedOn)) {
                return false;
            }
            return !(this.status == null ? other.status != null : !this.status.equals(other.status));
        }
    }
}

