/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.classpath;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import nonapi.io.github.classgraph.ScanSpec;
import nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandlerRegistry;
import nonapi.io.github.classgraph.classpath.ClassLoaderAndModuleFinder;
import nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import nonapi.io.github.classgraph.classpath.ClasspathOrder;
import nonapi.io.github.classgraph.classpath.SystemJarFinder;
import nonapi.io.github.classgraph.utils.FastPathResolver;
import nonapi.io.github.classgraph.utils.FileUtils;
import nonapi.io.github.classgraph.utils.JarUtils;
import nonapi.io.github.classgraph.utils.LogNode;

public class ClasspathFinder {
    private final ClasspathOrder classpathOrder;
    private final ClassLoaderAndModuleFinder classLoaderAndModuleFinder;
    private ClassLoader[] classLoaderOrderRespectingParentDelegation;

    public ClasspathOrder getClasspathOrder() {
        return this.classpathOrder;
    }

    public ClassLoaderAndModuleFinder getClassLoaderAndModuleFinder() {
        return this.classLoaderAndModuleFinder;
    }

    public ClassLoader[] getClassLoaderOrderRespectingParentDelegation() {
        return this.classLoaderOrderRespectingParentDelegation;
    }

    public ClasspathFinder(ScanSpec scanSpec, LogNode log) {
        ClassLoader defaultClassLoader;
        LogNode classpathFinderLog = log == null ? null : log.log("Finding classpath and modules");
        String jreRtJar = SystemJarFinder.getJreRtJarPath();
        boolean scanAllLibOrExtJars = !scanSpec.libOrExtJarWhiteBlackList.whitelistAndBlacklistAreEmpty();
        LogNode systemJarsLog = classpathFinderLog == null ? null : classpathFinderLog.log("System jars:");
        this.classLoaderAndModuleFinder = new ClassLoaderAndModuleFinder(scanSpec, classpathFinderLog);
        this.classpathOrder = new ClasspathOrder(scanSpec);
        ClasspathOrder ignoredClasspathOrder = new ClasspathOrder(scanSpec);
        ClassLoader[] contextClassLoaders = this.classLoaderAndModuleFinder.getContextClassLoaders();
        ClassLoader classLoader = defaultClassLoader = contextClassLoaders != null && contextClassLoaders.length > 0 ? contextClassLoaders[0] : null;
        if (scanSpec.overrideClasspath != null) {
            if (scanSpec.overrideClassLoaders != null && classpathFinderLog != null) {
                classpathFinderLog.log("It is not possible to override both the classpath and the ClassLoaders -- ignoring the ClassLoader override");
            }
            LogNode overrideLog = classpathFinderLog == null ? null : classpathFinderLog.log("Overriding classpath with: " + scanSpec.overrideClasspath);
            this.classpathOrder.addClasspathEntries(scanSpec.overrideClasspath, defaultClassLoader, scanSpec, overrideLog);
            if (overrideLog != null) {
                overrideLog.log("WARNING: when the classpath is overridden, there is no guarantee that the classes found by classpath scanning will be the same as the classes loaded by the context classloader");
            }
            this.classLoaderOrderRespectingParentDelegation = contextClassLoaders;
        } else {
            String[] pathElements;
            if (jreRtJar != null) {
                if (scanSpec.enableSystemJarsAndModules) {
                    this.classpathOrder.addSystemClasspathEntry(jreRtJar, defaultClassLoader);
                    if (systemJarsLog != null) {
                        systemJarsLog.log("Found rt.jar: " + jreRtJar);
                    }
                } else if (systemJarsLog != null) {
                    systemJarsLog.log((scanSpec.enableSystemJarsAndModules ? "" : "Scanning disabled for rt.jar: ") + jreRtJar);
                }
            }
            for (String string : SystemJarFinder.getJreLibOrExtJars()) {
                if (scanAllLibOrExtJars || scanSpec.libOrExtJarWhiteBlackList.isSpecificallyWhitelistedAndNotBlacklisted(string)) {
                    this.classpathOrder.addSystemClasspathEntry(string, defaultClassLoader);
                    if (systemJarsLog == null) continue;
                    systemJarsLog.log("Found lib or ext jar: " + string);
                    continue;
                }
                if (systemJarsLog == null) continue;
                systemJarsLog.log("Scanning disabled for lib or ext jar: " + string);
            }
            if (classpathFinderLog != null) {
                LogNode classLoaderHandlerLog = classpathFinderLog.log("ClassLoaderHandlers:");
                for (ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry classLoaderHandlerEntry : ClassLoaderHandlerRegistry.CLASS_LOADER_HANDLERS) {
                    classLoaderHandlerLog.log(classLoaderHandlerEntry.classLoaderHandlerClass.getName());
                }
            }
            ClassLoaderOrder classLoaderOrder = new ClassLoaderOrder();
            if (contextClassLoaders != null) {
                for (ClassLoader classLoader2 : contextClassLoaders) {
                    classLoaderOrder.delegateTo(classLoader2, false);
                }
            }
            Set<ClassLoader> set = classLoaderOrder.getAllParentClassLoaders();
            ArrayList<ClassLoader> finalClassLoaderOrder = new ArrayList<ClassLoader>();
            for (Map.Entry<ClassLoader, ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry> ent : classLoaderOrder.getClassLoaderOrder()) {
                ClassLoader classLoader3 = ent.getKey();
                ClassLoaderHandlerRegistry.ClassLoaderHandlerRegistryEntry classLoaderHandlerRegistryEntry = ent.getValue();
                if (scanSpec.ignoreParentClassLoaders && set.contains(classLoader3)) {
                    classLoaderHandlerRegistryEntry.findClasspathOrder(classLoader3, ignoredClasspathOrder, scanSpec, classpathFinderLog);
                    continue;
                }
                classLoaderHandlerRegistryEntry.findClasspathOrder(classLoader3, this.classpathOrder, scanSpec, classpathFinderLog);
                finalClassLoaderOrder.add(classLoader3);
            }
            this.classLoaderOrderRespectingParentDelegation = finalClassLoaderOrder.toArray(new ClassLoader[0]);
            if (scanSpec.overrideClassLoaders == null && scanSpec.overrideClasspath == null && (pathElements = JarUtils.smartPathSplit(System.getProperty("java.class.path"))).length > 0) {
                LogNode sysPropLog = classpathFinderLog == null ? null : classpathFinderLog.log("Getting classpath entries from java.class.path");
                for (String pathElement : pathElements) {
                    String pathElementResolved = FastPathResolver.resolve(FileUtils.CURR_DIR_PATH, pathElement);
                    if (!ignoredClasspathOrder.getClasspathEntryUniqueResolvedPaths().contains(pathElementResolved)) {
                        this.classpathOrder.addClasspathEntry(pathElement, defaultClassLoader, scanSpec, sysPropLog);
                        continue;
                    }
                    if (sysPropLog == null) continue;
                    sysPropLog.log("Found classpath element in java.class.path that will be ignored, since it is also found in an ignored parent classloader: " + pathElement);
                }
            }
        }
    }
}

