/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.prometheus;

import io.micrometer.core.instrument.AbstractTimer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.FixedBoundaryVictoriaMetricsHistogram;
import io.micrometer.core.instrument.distribution.Histogram;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import io.micrometer.core.instrument.distribution.TimeWindowMax;
import io.micrometer.core.instrument.distribution.pause.PauseDetector;
import io.micrometer.core.instrument.util.TimeUtils;
import io.micrometer.core.lang.Nullable;
import io.micrometer.prometheus.HistogramFlavor;
import io.micrometer.prometheus.PrometheusHistogram;
import io.prometheus.client.exemplars.Exemplar;
import io.prometheus.client.exemplars.HistogramExemplarSampler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class PrometheusTimer
extends AbstractTimer {
    private static final CountAtBucket[] EMPTY_HISTOGRAM = new CountAtBucket[0];
    private final LongAdder count = new LongAdder();
    private final LongAdder totalTime = new LongAdder();
    private final TimeWindowMax max;
    private final HistogramFlavor histogramFlavor;
    @Nullable
    private final Histogram histogram;
    private boolean exemplarsEnabled = false;

    PrometheusTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, HistogramFlavor histogramFlavor, @Nullable HistogramExemplarSampler exemplarSampler) {
        super(id, clock, DistributionStatisticConfig.builder().percentilesHistogram(Boolean.valueOf(false)).serviceLevelObjectives(new double[0]).build().merge(distributionStatisticConfig), pauseDetector, TimeUnit.SECONDS, false);
        this.histogramFlavor = histogramFlavor;
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
        if (distributionStatisticConfig.isPublishingHistogram()) {
            switch (histogramFlavor) {
                case Prometheus: {
                    PrometheusHistogram prometheusHistogram = new PrometheusHistogram(clock, distributionStatisticConfig, exemplarSampler);
                    this.histogram = prometheusHistogram;
                    this.exemplarsEnabled = prometheusHistogram.isExemplarsEnabled();
                    break;
                }
                case VictoriaMetrics: {
                    this.histogram = new FixedBoundaryVictoriaMetricsHistogram();
                    break;
                }
                default: {
                    this.histogram = null;
                    break;
                }
            }
        } else {
            this.histogram = null;
        }
    }

    protected void recordNonNegative(long amount, TimeUnit unit) {
        this.count.increment();
        long nanoAmount = TimeUnit.NANOSECONDS.convert(amount, unit);
        this.totalTime.add(nanoAmount);
        this.max.record((double)nanoAmount, TimeUnit.NANOSECONDS);
        if (this.histogram != null) {
            this.histogram.recordLong(TimeUnit.NANOSECONDS.convert(amount, unit));
        }
    }

    @Nullable
    Exemplar[] exemplars() {
        if (this.exemplarsEnabled) {
            return ((PrometheusHistogram)this.histogram).exemplars();
        }
        return null;
    }

    public long count() {
        return this.count.longValue();
    }

    public double totalTime(TimeUnit unit) {
        return TimeUtils.nanosToUnit((double)this.totalTime.doubleValue(), (TimeUnit)unit);
    }

    public double max(TimeUnit unit) {
        return this.max.poll(unit);
    }

    public HistogramFlavor histogramFlavor() {
        return this.histogramFlavor;
    }

    public CountAtBucket[] histogramCounts() {
        return this.histogram == null ? EMPTY_HISTOGRAM : this.histogram.takeSnapshot(0L, 0.0, 0.0).histogramCounts();
    }

    public HistogramSnapshot takeSnapshot() {
        HistogramSnapshot snapshot = super.takeSnapshot();
        if (this.histogram == null) {
            return snapshot;
        }
        return new HistogramSnapshot(snapshot.count(), snapshot.total(), snapshot.max(), snapshot.percentileValues(), this.histogramCounts(), (arg_0, arg_1) -> ((HistogramSnapshot)snapshot).outputSummary(arg_0, arg_1));
    }
}

