/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handler.resourceregistry.resourcemanager;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.informationsystem.model.impl.properties.HeaderImpl;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.contexts.ContextNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entities.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisherFactory;
import org.gcube.informationsystem.serialization.ElementMapper;
import org.gcube.resourcemanagement.model.impl.entities.facets.CPUFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.EventFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.LocationFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.MemoryFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.NetworkingFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.SimplePropertyFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.SoftwareFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.StateFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.resources.HostingNodeImpl;
import org.gcube.resourcemanagement.model.impl.relations.consistsof.HasPersistentMemoryImpl;
import org.gcube.resourcemanagement.model.impl.relations.consistsof.HasVolatileMemoryImpl;
import org.gcube.resourcemanagement.model.impl.relations.consistsof.IsIdentifiedByImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.CPUFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.EventFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.MemoryFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.SimplePropertyFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.SoftwareFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.StateFacet;
import org.gcube.resourcemanagement.model.reference.entities.resources.HostingNode;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasPersistentMemory;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.HasVolatileMemory;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.configuration.container.Site;
import org.gcube.smartgears.configuration.library.SmartGearsConfiguration;
import org.gcube.smartgears.context.container.ContainerContext;
import org.gcube.smartgears.handler.resourceregistry.ContextUtility;
import org.gcube.smartgears.handler.resourceregistry.resourcemanager.LinuxDistributionInfo;
import org.gcube.smartgears.lifecycle.container.ContainerState;
import org.gcube.smartgears.provider.ProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostingNodeManager {
    private static Logger logger = LoggerFactory.getLogger(HostingNodeManager.class);
    public static final String MEMORY_TYPE = "memoryType";
    public static final String MEMORY_TYPE_RAM = "RAM";
    public static final String MEMORY_TYPE_JVM = "JVM";
    public static final String JVM_MAX_MEMORY = "jvmMaxMemory";
    public static final String MESSAGE = "message";
    private ContainerContext containerContext;
    private ResourceRegistryPublisher resourceRegistryPublisher;
    private HostingNode hostingNode;
    private static final long BYTE_TO_MB = 0x100000L;
    public static final String CPU_PROCESSOR = "processor";
    public static final String CPU_VENDOR_ID = "vendor_id";
    public static final String CPU_MODEL_NAME = "model name";
    public static final String CPU_CPU_MHZ = "cpu MHz";
    public static final String CPU_MODEL_T = "model\t";
    public static final String CPU_MODEL_B = "model\b";
    public static final String CPU_MODEL_NUMBER = "modelNumber";

    public HostingNodeManager(ContainerContext containerContext) {
        this.containerContext = containerContext;
        this.resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
    }

    public HostingNode getHostingNode() {
        return this.hostingNode;
    }

    public void addToCurrentContext() throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        String currentToken = SecurityTokenProvider.instance.get();
        UUID contextUUID = ContextUtility.getContextUUID(currentToken);
        boolean anotherContextSet = false;
        List startTokens = this.containerContext.configuration().startTokens();
        for (String token : startTokens) {
            UUID anotherContextUUID = ContextUtility.getContextUUID(token);
            if (anotherContextUUID.compareTo(contextUUID) == 0) continue;
            ContextUtility.setContextFromToken(token);
            anotherContextSet = true;
            break;
        }
        UUID uuid = UUID.fromString(this.containerContext.id());
        try {
            if (anotherContextSet) {
                this.resourceRegistryPublisher.addToContext("HostingNode", uuid, contextUUID, Boolean.valueOf(false));
            } else {
                this.resourceRegistryPublisher.addResourceToCurrentContext("HostingNode", uuid, Boolean.valueOf(false));
            }
            logger.info("{} with UUID {} successfully added to context ({})", new Object[]{"HostingNode", uuid, ContextUtility.getCurrentContextName()});
        }
        catch (Exception e) {
            logger.error("Unable to add {} with UUID {} to context ({})", new Object[]{"HostingNode", uuid, ContextUtility.getCurrentContextName(), e});
        }
    }

    public void addToContext(UUID contextUUID) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        UUID uuid = UUID.fromString(this.containerContext.id());
        try {
            this.resourceRegistryPublisher.addToContext("HostingNode", uuid, contextUUID, Boolean.valueOf(false));
            logger.info("{} with UUID {} successfully added to context ({})", new Object[]{"HostingNode", uuid, ContextUtility.getContextNameFromUUID(contextUUID)});
        }
        catch (Exception e) {
            logger.error("Unable to add {} with UUID {} to context ({})", new Object[]{"HostingNode", uuid, ContextUtility.getContextNameFromUUID(contextUUID), e});
        }
    }

    public void removeFromCurrentContext() throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        UUID uuid = UUID.fromString(this.containerContext.id());
        try {
            this.resourceRegistryPublisher.removeResourceFromCurrentContext("HostingNode", uuid, Boolean.valueOf(false));
            logger.info("{} with UUID {} successfully removed from context ({})", new Object[]{"HostingNode", uuid, ContextUtility.getCurrentContextName()});
        }
        catch (Exception e) {
            logger.error("Unable to remove {} with UUID {} from context ({})", new Object[]{"HostingNode", uuid, ContextUtility.getCurrentContextName(), e});
        }
    }

    public void removeFromContext(UUID contextUUID) throws ResourceNotFoundException, ContextNotFoundException, ResourceRegistryException {
        String contextFullName = ContextUtility.getContextNameFromUUID(contextUUID);
        UUID uuid = UUID.fromString(this.containerContext.id());
        try {
            this.resourceRegistryPublisher.removeResourceFromContext("HostingNode", uuid, contextUUID, Boolean.valueOf(false));
            logger.info("{} with UUID {} successfully removed from context ({})", new Object[]{"HostingNode", uuid, contextFullName});
        }
        catch (Exception e) {
            logger.error("Unable to remove {} from context ({})", new Object[]{"HostingNode", uuid, contextFullName, e});
        }
    }

    public HostingNode updateFacets() throws ResourceRegistryException {
        logger.debug("Updating {}", (Object)"HostingNode");
        MemoryFacet ramFacet = null;
        MemoryFacet jvmMemoryFacet = null;
        MemoryFacet disk = null;
        StateFacet stateFacet = null;
        EventFacet eventFacet = null;
        Date date = Calendar.getInstance().getTime();
        ArrayList<ConsistsOf> consistsOfToRemove = new ArrayList<ConsistsOf>();
        List consistsOfList = this.hostingNode.getConsistsOf();
        for (ConsistsOf c : consistsOfList) {
            if (c.getTarget() instanceof StateFacet) {
                stateFacet = (StateFacet)c.getTarget();
                stateFacet = this.getStateFacet(stateFacet, date);
                continue;
            }
            if (c instanceof HasVolatileMemory) {
                String memoryType = (String)c.getAdditionalProperty(MEMORY_TYPE);
                if (memoryType.compareTo(MEMORY_TYPE_RAM) == 0) {
                    ramFacet = (MemoryFacet)c.getTarget();
                    ramFacet = this.getRamInfo(ramFacet);
                    continue;
                }
                if (memoryType.compareTo(MEMORY_TYPE_JVM) == 0) {
                    jvmMemoryFacet = (MemoryFacet)c.getTarget();
                    jvmMemoryFacet = this.getJVMMemoryInfo(jvmMemoryFacet);
                    continue;
                }
            }
            if (c instanceof HasPersistentMemory) {
                disk = (MemoryFacet)c.getTarget();
                disk = this.getDiskSpace(disk);
                continue;
            }
            if (c.getTarget() instanceof EventFacet) {
                eventFacet = (EventFacet)c.getTarget();
                String value = eventFacet.getEvent();
                if (value.compareTo(this.getState()) == 0) {
                    eventFacet.setDate(date);
                    continue;
                }
                eventFacet = null;
            }
            consistsOfToRemove.add(c);
        }
        consistsOfList.removeAll(consistsOfToRemove);
        if (eventFacet == null) {
            eventFacet = this.getEventFacet(date);
            this.hostingNode.addFacet((Facet)eventFacet);
        }
        try {
            this.hostingNode = (HostingNode)this.resourceRegistryPublisher.updateResource((Resource)this.hostingNode);
        }
        catch (ResourceRegistryException e) {
            logger.error("error trying to publish hosting node", (Throwable)e);
        }
        return this.hostingNode;
    }

    public static SoftwareFacet getOperativeSystem() {
        SoftwareFacetImpl osSoftwareFacet = new SoftwareFacetImpl();
        OperatingSystemMXBean mxbean = ManagementFactory.getOperatingSystemMXBean();
        String osName = mxbean.getName();
        osSoftwareFacet.setGroup(osName);
        osSoftwareFacet.setName(mxbean.getArch());
        osSoftwareFacet.setVersion(mxbean.getVersion());
        JsonNode jsonNode = ElementMapper.getObjectMapper().valueToTree((Object)osSoftwareFacet);
        TreeSet<String> fieldNames = new TreeSet<String>();
        Iterator it = jsonNode.fieldNames();
        while (it.hasNext()) {
            fieldNames.add((String)it.next());
        }
        if (osName.compareTo("Linux") == 0) {
            LinuxDistributionInfo linuxDistributionInfo = new LinuxDistributionInfo();
            Map<String, String> map = linuxDistributionInfo.getInfo();
            Set<String> keys = map.keySet();
            Iterator<String> iterator = keys.iterator();
            while (iterator.hasNext()) {
                String key;
                String k = key = iterator.next();
                if (fieldNames.contains(key)) {
                    k = "linuxDistribution-" + k;
                }
                osSoftwareFacet.setAdditionalProperty(k, (Object)map.get(key));
            }
        }
        return osSoftwareFacet;
    }

    private HostingNode instantiateHostingNode() {
        logger.info("Creating {}", (Object)"HostingNode");
        ContainerConfiguration containerConfiguration = this.containerContext.configuration();
        String id = this.containerContext.id();
        UUID uuid = UUID.fromString(id);
        HostingNodeImpl hostingNode = new HostingNodeImpl();
        HeaderImpl header = new HeaderImpl(uuid);
        hostingNode.setHeader((Header)header);
        NetworkingFacetImpl networkingFacet = new NetworkingFacetImpl();
        try {
            networkingFacet.setIPAddress(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            logger.warn("unable to detect the IP address of the host");
        }
        String hostname = containerConfiguration.hostname();
        networkingFacet.setHostName(hostname);
        networkingFacet.setDomainName(HostingNodeManager.getDomain(hostname));
        networkingFacet.setAdditionalProperty("Port", (Object)containerConfiguration.port());
        IsIdentifiedByImpl isIdentifiedBy = new IsIdentifiedByImpl((Resource)hostingNode, (Facet)networkingFacet);
        hostingNode.addFacet((ConsistsOf)isIdentifiedBy);
        List<CPUFacet> cpuFacets = HostingNodeManager.getCPUFacets();
        for (CPUFacet cpuFacet : cpuFacets) {
            hostingNode.addFacet((Facet)cpuFacet);
        }
        SoftwareFacet osSoftwareFacet = HostingNodeManager.getOperativeSystem();
        hostingNode.addFacet((Facet)osSoftwareFacet);
        SmartGearsConfiguration config = ProviderFactory.provider().smartgearsConfiguration();
        SoftwareFacetImpl smartgearsSoftwareFacet = new SoftwareFacetImpl();
        smartgearsSoftwareFacet.setGroup("gCube");
        smartgearsSoftwareFacet.setName("SmartGears");
        smartgearsSoftwareFacet.setVersion(config.version());
        hostingNode.addFacet((Facet)smartgearsSoftwareFacet);
        SoftwareFacetImpl smartgearsDistributionSoftwareFacet = new SoftwareFacetImpl();
        smartgearsDistributionSoftwareFacet.setGroup("gCube");
        smartgearsDistributionSoftwareFacet.setName("SmartGearsDistribution");
        String smartgearsDistributionVersion = (String)containerConfiguration.properties().get("SmartGearsDistribution");
        smartgearsDistributionSoftwareFacet.setVersion(smartgearsDistributionVersion);
        smartgearsDistributionSoftwareFacet.setAdditionalProperty("publication-frequency", (Object)String.valueOf(containerConfiguration.publicationFrequency()));
        hostingNode.addFacet((Facet)smartgearsDistributionSoftwareFacet);
        SoftwareFacetImpl javaSoftwareFacet = new SoftwareFacetImpl();
        javaSoftwareFacet.setGroup(System.getProperty("java.vendor"));
        javaSoftwareFacet.setName("Java");
        javaSoftwareFacet.setVersion(System.getProperty("java.version"));
        javaSoftwareFacet.setAdditionalProperty("java.vendor.url", (Object)System.getProperty("java.vendor.url"));
        javaSoftwareFacet.setAdditionalProperty("java.specification.version", (Object)System.getProperty("java.specification.version"));
        hostingNode.addFacet((Facet)javaSoftwareFacet);
        SimplePropertyFacet simplePropertyFacet = this.addEnvironmentVariables(containerConfiguration);
        hostingNode.addFacet((Facet)simplePropertyFacet);
        Date date = Calendar.getInstance().getTime();
        StateFacet stateFacet = this.getStateFacet(null, date);
        hostingNode.addFacet((Facet)stateFacet);
        EventFacet eventFacet = this.getEventFacet(date);
        hostingNode.addFacet((Facet)eventFacet);
        MemoryFacet ramFacet = this.getRamInfo(null);
        HasVolatileMemoryImpl hasVolatileRAMMemory = new HasVolatileMemoryImpl((Resource)hostingNode, ramFacet, null);
        hasVolatileRAMMemory.setAdditionalProperty(MEMORY_TYPE, (Object)MEMORY_TYPE_RAM);
        hostingNode.addFacet((ConsistsOf)hasVolatileRAMMemory);
        MemoryFacet jvmMemoryFacet = this.getJVMMemoryInfo(null);
        HasVolatileMemoryImpl hasVolatileJVMMemory = new HasVolatileMemoryImpl((Resource)hostingNode, jvmMemoryFacet, null);
        hasVolatileJVMMemory.setAdditionalProperty(MEMORY_TYPE, (Object)MEMORY_TYPE_JVM);
        hostingNode.addFacet((ConsistsOf)hasVolatileJVMMemory);
        MemoryFacet diskFacet = this.getDiskSpace(null);
        HasPersistentMemoryImpl hasPersistentMemory = new HasPersistentMemoryImpl((Resource)hostingNode, diskFacet, null);
        hostingNode.addFacet((ConsistsOf)hasPersistentMemory);
        LocationFacetImpl locationFacet = new LocationFacetImpl();
        Site site = containerConfiguration.site();
        locationFacet.setCountry(site.country());
        locationFacet.setLocation(site.location());
        locationFacet.setLatitude(site.latitude());
        locationFacet.setLongitude(site.longitude());
        hostingNode.addFacet((Facet)locationFacet);
        logger.info("{} with UUID {} instantiated", (Object)"HostingNode", (Object)uuid);
        return hostingNode;
    }

    public HostingNode createHostingNode() throws ResourceRegistryException {
        ResourceRegistryClient resourceRegistryClient = ResourceRegistryClientFactory.create();
        UUID uuid = UUID.fromString(this.containerContext.id());
        try {
            this.hostingNode = (HostingNode)resourceRegistryClient.getInstance(HostingNode.class, uuid);
            this.hostingNode = this.updateFacets();
        }
        catch (NotFoundException e) {
            this.hostingNode = this.instantiateHostingNode();
            this.hostingNode = (HostingNode)this.resourceRegistryPublisher.createResource((Resource)this.hostingNode);
        }
        catch (AvailableInAnotherContextException e) {
            this.addToCurrentContext();
            this.hostingNode = (HostingNode)resourceRegistryClient.getInstance(HostingNode.class, uuid);
        }
        catch (ResourceRegistryException e) {
            logger.error("", (Throwable)e);
        }
        return this.hostingNode;
    }

    public String getState() {
        return ((ContainerState)this.containerContext.lifecycle().state()).remoteForm().toLowerCase();
    }

    private StateFacet getStateFacet(StateFacet stateFacet, Date date) {
        if (stateFacet == null) {
            stateFacet = new StateFacetImpl();
        }
        String state = this.getState();
        stateFacet.setValue(state);
        stateFacet.setAdditionalProperty("date", (Object)date);
        return stateFacet;
    }

    private EventFacet getEventFacet(Date date) {
        EventFacetImpl eventFacet = new EventFacetImpl();
        eventFacet.setDate(date);
        String state = this.getState();
        eventFacet.setEvent(state);
        return eventFacet;
    }

    private MemoryFacet getDiskSpace(MemoryFacet memoryFacet) {
        if (memoryFacet == null) {
            memoryFacet = new MemoryFacetImpl();
        }
        long free = 0L;
        long total = 0L;
        try {
            FileStore fileStore = Files.getFileStore(Paths.get(this.containerContext.configuration().persistence().location(), new String[0]));
            free = fileStore.getUsableSpace() / 0x100000L;
            total = fileStore.getTotalSpace() / 0x100000L;
        }
        catch (IOException ioe) {
            logger.warn("Unable to detect disk space information", (Throwable)ioe);
            memoryFacet.setAdditionalProperty(MESSAGE, (Object)"Unable to detect disk space information.");
        }
        memoryFacet.setUnit(MemoryFacet.MemoryUnit.MB);
        memoryFacet.setSize(total);
        memoryFacet.setUsed(total - free);
        return memoryFacet;
    }

    private MemoryFacet getRamInfo(MemoryFacet memoryFacet) {
        long totalMemory;
        long freeMemory;
        if (memoryFacet == null) {
            memoryFacet = new MemoryFacetImpl();
        }
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            freeMemory = Long.parseLong(mBeanServer.getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "FreePhysicalMemorySize").toString()) / 0x100000L;
        }
        catch (NumberFormatException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            logger.warn("Unable to get free memory from Operating System. Going to get JVM Memory. Better than nothing");
            long allocatedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            freeMemory = Runtime.getRuntime().maxMemory() - allocatedMemory;
        }
        try {
            totalMemory = Long.parseLong(mBeanServer.getAttribute(new ObjectName("java.lang", "type", "OperatingSystem"), "TotalPhysicalMemorySize").toString()) / 0x100000L;
        }
        catch (NumberFormatException | AttributeNotFoundException | InstanceNotFoundException | MBeanException | MalformedObjectNameException | ReflectionException e) {
            logger.warn("Unable to total memory from Operating System. Going to get JVM Memory. Better than nothing");
            totalMemory = Runtime.getRuntime().maxMemory();
        }
        memoryFacet.setUnit(MemoryFacet.MemoryUnit.MB);
        memoryFacet.setSize(totalMemory);
        memoryFacet.setUsed(totalMemory - freeMemory);
        return memoryFacet;
    }

    private MemoryFacet getJVMMemoryInfo(MemoryFacet memoryFacet) {
        if (memoryFacet == null) {
            memoryFacet = new MemoryFacetImpl();
        }
        long jvmFreeMemory = Runtime.getRuntime().freeMemory() / 0x100000L;
        long jvmTotalMemory = Runtime.getRuntime().totalMemory() / 0x100000L;
        long jvmMaxMemory = Runtime.getRuntime().maxMemory() / 0x100000L;
        memoryFacet.setUnit(MemoryFacet.MemoryUnit.MB);
        memoryFacet.setSize(jvmTotalMemory);
        memoryFacet.setUsed(jvmTotalMemory - jvmFreeMemory);
        memoryFacet.setAdditionalProperty(JVM_MAX_MEMORY, (Object)jvmMaxMemory);
        return memoryFacet;
    }

    private static String sanitizeKey(String key) {
        return key.trim().replace(" ", "_");
    }

    private SimplePropertyFacet addEnvironmentVariables(ContainerConfiguration containerConfiguration) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll(containerConfiguration.properties());
        map.putAll(System.getenv());
        SimplePropertyFacetImpl simplePropertyFacet = new SimplePropertyFacetImpl();
        simplePropertyFacet.setName("ENVIRONMENT_VARIABLES");
        simplePropertyFacet.setValue("");
        for (Map.Entry entry : map.entrySet()) {
            String varname = (String)entry.getKey();
            if (varname.compareToIgnoreCase("CLASSPATH") == 0 || varname.compareToIgnoreCase("PATH") == 0 || varname.contains("SSH") || varname.contains("MAIL") || varname.compareToIgnoreCase("LS_COLORS") == 0) continue;
            simplePropertyFacet.setAdditionalProperty(HostingNodeManager.sanitizeKey((String)entry.getKey()), entry.getValue());
        }
        return simplePropertyFacet;
    }

    private static String getDomain(String hostname) {
        try {
            Pattern pattern = Pattern.compile("([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})");
            Matcher regexMatcher = pattern.matcher(hostname);
            if (regexMatcher.matches()) {
                return hostname;
            }
            return hostname.substring(hostname.indexOf(".") + 1);
        }
        catch (Exception e) {
            logger.warn("Error while getting domain from hostname");
            return hostname;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CPUFacet> getCPUFacets() {
        ArrayList<CPUFacet> cpuFacets = new ArrayList<CPUFacet>();
        File file = new File("/proc/cpuinfo");
        if (!file.exists()) {
            logger.warn("cannot acquire CPU info (no /proc/cpuinfo)");
            return cpuFacets;
        }
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(file));
            String line = null;
            CPUFacetImpl cpuFacet = null;
            while ((line = input.readLine()) != null) {
                if (line.startsWith(CPU_PROCESSOR)) {
                    cpuFacet = new CPUFacetImpl();
                    cpuFacets.add((CPUFacet)cpuFacet);
                }
                try {
                    if (line.contains(CPU_VENDOR_ID)) {
                        cpuFacet.setVendor(line.split(":")[1].trim());
                    }
                }
                catch (Exception e) {}
                continue;
                try {
                    if (line.contains(CPU_MODEL_NAME)) {
                        cpuFacet.setModel(line.split(":")[1].trim());
                    }
                }
                catch (Exception e) {}
                continue;
                try {
                    if (line.contains(CPU_CPU_MHZ)) {
                        cpuFacet.setClockSpeed(line.split(":")[1].trim());
                    }
                }
                catch (Exception e) {}
                continue;
                try {
                    if (line.contains(CPU_MODEL_T) || line.contains(CPU_MODEL_B)) {
                        cpuFacet.setAdditionalProperty(CPU_MODEL_NUMBER, (Object)line.split(":")[1].trim());
                    }
                }
                catch (Exception e) {}
                continue;
                try {
                    String[] nameValue = line.split(":");
                    cpuFacet.setAdditionalProperty(HostingNodeManager.sanitizeKey(nameValue[0]), (Object)line.split(":")[1].trim());
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception e) {
            logger.warn("unable to acquire CPU info", (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.warn("unable to close stream", (Throwable)e);
                }
            }
        }
        return cpuFacets;
    }

    public Map<UUID, String> getContextsUUID() throws Exception {
        return this.resourceRegistryPublisher.getResourceContexts((Resource)this.hostingNode);
    }
}

