/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.lifecycle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gcube.common.authorization.client.proxy.AuthorizationProxy;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.informationsystem.publisher.ScopedPublisher;
import org.gcube.smartgears.configuration.Mode;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.provider.ProviderFactory;
import org.gcube.smartgears.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilePublisher {
    private static final Logger log = LoggerFactory.getLogger(ProfilePublisher.class);
    private final ScopedPublisher publisher;
    private final ApplicationContext context;
    private AuthorizationProxy authProxy;

    public ProfilePublisher(ApplicationContext context) {
        this.context = context;
        this.publisher = ProviderFactory.provider().publisherFor(context);
        this.authProxy = ProviderFactory.provider().authorizationProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTo(Collection<String> tokens) {
        Utils.notEmpty("tokens", tokens);
        GCoreEndpoint profile = this.context.profile(GCoreEndpoint.class);
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        log.debug("using context {}", (Object)contextCL.getClass().getSimpleName());
        String previousToken = SecurityTokenProvider.instance.get();
        try {
            if (previousToken == null) {
                SecurityTokenProvider.instance.set((String)tokens.toArray()[0]);
            }
            if (this.context.container().configuration().mode() != Mode.root) {
                Thread.currentThread().setContextClassLoader(ProfilePublisher.class.getClassLoader());
            }
            profile = (GCoreEndpoint)this.publisher.create((Resource)profile, this.resolveScopesFromTokens(tokens));
        }
        catch (Exception e) {
            Utils.rethrowUnchecked(e);
        }
        finally {
            SecurityTokenProvider.instance.set(previousToken);
            if (this.context.container().configuration().mode() != Mode.root) {
                Thread.currentThread().setContextClassLoader(contextCL);
            }
        }
        this.sharePublished(profile);
        log.debug("shared profile with scopes {}", (Object)profile.scopes().asCollection());
    }

    public void addToAll() {
        this.addTo(this.context.configuration().startTokens());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        GCoreEndpoint profile = this.context.profile(GCoreEndpoint.class);
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        log.debug("using context {}", (Object)contextCL.getClass().getSimpleName());
        String previousToken = SecurityTokenProvider.instance.get();
        try {
            if (previousToken == null) {
                SecurityTokenProvider.instance.set((String)this.context.configuration().startTokens().toArray()[0]);
            }
            if (this.context.container().configuration().mode() != Mode.root) {
                Thread.currentThread().setContextClassLoader(ProfilePublisher.class.getClassLoader());
            }
            profile = (GCoreEndpoint)this.publisher.update((Resource)profile);
        }
        catch (Exception e) {
            Utils.rethrowUnchecked(e);
        }
        finally {
            SecurityTokenProvider.instance.set(previousToken);
            if (this.context.container().configuration().mode() != Mode.root) {
                Thread.currentThread().setContextClassLoader(contextCL);
            }
        }
        this.sharePublished(profile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFrom(Collection<String> tokens) {
        GCoreEndpoint profile = this.context.profile(GCoreEndpoint.class);
        ClassLoader contextCL = Thread.currentThread().getContextClassLoader();
        log.debug("using context {}", (Object)contextCL.getClass().getSimpleName());
        String previousToken = SecurityTokenProvider.instance.get();
        try {
            if (previousToken == null) {
                SecurityTokenProvider.instance.set((String)tokens.toArray()[0]);
            }
            if (this.context.container().configuration().mode() != Mode.root) {
                Thread.currentThread().setContextClassLoader(ProfilePublisher.class.getClassLoader());
            }
            profile = (GCoreEndpoint)this.publisher.remove((Resource)profile, this.resolveScopesFromTokens(tokens));
        }
        catch (Exception e) {
            Utils.rethrowUnchecked(e);
        }
        finally {
            SecurityTokenProvider.instance.set(previousToken);
            if (this.context.container().configuration().mode() != Mode.root) {
                Thread.currentThread().setContextClassLoader(contextCL);
            }
        }
        log.debug("after remove application profile contains scopes {}", (Object)profile.scopes().asCollection());
        this.sharePublished(profile);
    }

    private void sharePublished(GCoreEndpoint profile) {
        this.context.events().fire((Object)profile, new String[]{"published"});
    }

    private List<String> resolveScopesFromTokens(Collection<String> tokens) {
        ArrayList<String> scopes = new ArrayList<String>(tokens.size());
        for (String token : tokens) {
            try {
                scopes.add(this.authProxy.get(token).getContext());
            }
            catch (Exception e) {
                log.warn("error retrieving token {} , it should never happen", (Object)token);
            }
        }
        return scopes;
    }
}

