/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.gcube.com.fasterxml.jackson.core.JsonGenerationException;
import org.gcube.com.fasterxml.jackson.core.JsonParseException;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.com.fasterxml.jackson.databind.DeserializationFeature;
import org.gcube.com.fasterxml.jackson.databind.JavaType;
import org.gcube.com.fasterxml.jackson.databind.JsonMappingException;
import org.gcube.com.fasterxml.jackson.databind.JsonNode;
import org.gcube.com.fasterxml.jackson.databind.Module;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.module.SimpleModule;
import org.gcube.com.fasterxml.jackson.databind.node.ArrayNode;
import org.gcube.com.fasterxml.jackson.databind.node.JsonNodeType;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.com.fasterxml.jackson.databind.node.TextNode;
import org.gcube.com.fasterxml.jackson.databind.type.CollectionType;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.base.reference.Element;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.informationsystem.utils.ElementDeserializer;
import org.gcube.informationsystem.utils.ElementMappingAction;
import org.gcube.informationsystem.utils.discovery.ElementSpecilizationDiscovery;
import org.gcube.informationsystem.utils.discovery.RegistrationProvider;
import org.gcube.informationsystem.utils.discovery.SchemaAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ElementMapper {
    private static Logger logger;
    protected static final ObjectMapper mapper;
    protected static final Map<String, Class<? extends Element>> knownTypes;

    public static ObjectMapper getObjectMapper() {
        return mapper;
    }

    public static void registerPackages(List<Package> packages) {
        ElementMappingAction schemaAction = new ElementMappingAction();
        try {
            ElementSpecilizationDiscovery.manageISM((SchemaAction)schemaAction, packages);
        }
        catch (Exception e) {
            logger.error("Error registering types", (Throwable)e);
        }
    }

    public static void registerPackages(Package ... packages) {
        ElementMappingAction schemaAction = new ElementMappingAction();
        try {
            ElementSpecilizationDiscovery.manageISM((SchemaAction)schemaAction, packages);
        }
        catch (Exception e) {
            logger.error("Error registering types", (Throwable)e);
        }
    }

    public static <El extends Element> void registerSubtypes(Class<El> clz, Class<El> implementationClass) {
        String typeName = TypeMapper.getType(clz);
        SimpleModule isModule = new SimpleModule(typeName);
        isModule.addDeserializer(clz, new ElementDeserializer<El>(clz, mapper));
        mapper.registerModule((Module)isModule);
        ElementMapper.registerSubtype(implementationClass);
    }

    public static <El extends Element> void registerSubtype(Class<El> clz) {
        String typeName = TypeMapper.getType(clz);
        knownTypes.put(typeName, clz);
        mapper.registerSubtypes(new Class[]{clz});
    }

    public static <T extends OutputStream, El extends Element> T marshal(El object, T stream) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(stream, object);
        return stream;
    }

    public static <T extends Writer, El extends Element> T marshal(El object, T writer) throws JsonGenerationException, JsonMappingException, IOException {
        mapper.writeValue(writer, object);
        return writer;
    }

    public static <El extends Element> String marshal(El object) throws JsonProcessingException {
        return mapper.writeValueAsString(object);
    }

    public static <El extends Element> String marshal(List<El> list) throws JsonProcessingException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, Element.class);
        return mapper.writerFor((JavaType)type).writeValueAsString(list);
    }

    public static <El extends Element> String marshal(El[] array) throws JsonProcessingException {
        return mapper.writeValueAsString(array);
    }

    protected static StringBuffer getError(String unknownType) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(unknownType);
        stringBuffer.append(" is an unknown type. Please provide ");
        stringBuffer.append("@superClasses");
        stringBuffer.append(" property as string array to allow to instantiate the most appropriated class.");
        return stringBuffer;
    }

    protected static JsonNode setAvailableSuperclass(JsonNode jsonNode) {
        String unknownType = jsonNode.get("@class").asText();
        ArrayNode arrayNode = (ArrayNode)jsonNode.get("@superClasses");
        String candidatedSuperClass = null;
        for (int i = 0; i < arrayNode.size(); ++i) {
            String superClass = arrayNode.get(i).asText();
            if (!knownTypes.containsKey(superClass)) continue;
            candidatedSuperClass = superClass;
            try {
                AccessType accessType = Enum.valueOf(AccessType.class, superClass.toUpperCase());
                if (accessType.getDummyImplementationClass() == null) break;
                candidatedSuperClass = accessType.getDummyImplementationClass().getSimpleName();
            }
            catch (Exception exception) {}
            break;
        }
        if (candidatedSuperClass != null) {
            ((ObjectNode)jsonNode).set("@class", (JsonNode)new TextNode(candidatedSuperClass));
            return jsonNode;
        }
        StringBuffer stringBuffer = ElementMapper.getError(unknownType);
        logger.trace("Unable to unmarshall {}. {}", (Object)jsonNode.toString(), (Object)stringBuffer.toString());
        throw new RuntimeException(stringBuffer.toString());
    }

    protected static JsonNode analizeFullJson(JsonNode jsonNode) {
        String cls = jsonNode.get("@class").asText();
        if (!knownTypes.containsKey(cls)) {
            jsonNode = ElementMapper.setAvailableSuperclass(jsonNode);
        }
        Iterator iterator = jsonNode.fieldNames();
        while (iterator.hasNext()) {
            String fieldName = (String)iterator.next();
            JsonNode jn = jsonNode.get(fieldName);
            if (jn.getNodeType() != JsonNodeType.OBJECT) continue;
            jn = ElementMapper.analizeFullJson(jn);
            ((ObjectNode)jsonNode).set(fieldName, jn);
        }
        return jsonNode;
    }

    public static <El extends Element> El unmarshal(Class<El> clz, Reader reader) throws JsonParseException, JsonMappingException, IOException {
        try {
            return (El)((Element)mapper.readValue(reader, clz));
        }
        catch (JsonMappingException e) {
            JsonNode jsonNode = mapper.readTree(reader);
            jsonNode = ElementMapper.analizeFullJson(jsonNode);
            return ElementMapper.unmarshal(clz, mapper.writeValueAsString((Object)jsonNode));
        }
    }

    public static <El extends Element> El unmarshal(Class<El> clz, InputStream stream) throws JsonParseException, JsonMappingException, IOException {
        try {
            return (El)((Element)mapper.readValue(stream, clz));
        }
        catch (JsonMappingException e) {
            JsonNode jsonNode = mapper.readTree(stream);
            jsonNode = ElementMapper.analizeFullJson(jsonNode);
            return ElementMapper.unmarshal(clz, mapper.writeValueAsString((Object)jsonNode));
        }
    }

    public static <El extends Element> El unmarshal(Class<El> clz, String string) throws JsonParseException, JsonMappingException, IOException {
        try {
            return (El)((Element)mapper.readValue(string, clz));
        }
        catch (JsonMappingException e) {
            JsonNode jsonNode = mapper.readTree(string);
            jsonNode = ElementMapper.analizeFullJson(jsonNode);
            return ElementMapper.unmarshal(clz, mapper.writeValueAsString((Object)jsonNode));
        }
    }

    public static <El extends Element> List<El> unmarshalList(Class<El> clz, String string) throws JsonParseException, JsonMappingException, IOException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, clz);
        try {
            return (List)mapper.readValue(string, (JavaType)type);
        }
        catch (JsonMappingException e) {
            ArrayList<El> ret = new ArrayList<El>();
            ArrayNode arrayNode = (ArrayNode)mapper.readTree(string);
            for (JsonNode jsonNode : arrayNode) {
                jsonNode = ElementMapper.analizeFullJson(jsonNode);
                ret.add(ElementMapper.unmarshal(clz, mapper.writeValueAsString((Object)jsonNode)));
            }
            return ret;
        }
    }

    public static <El extends Element> List<El> unmarshalList(String string) throws JsonParseException, JsonMappingException, IOException {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(ArrayList.class, Element.class);
        try {
            return (List)mapper.readValue(string, (JavaType)type);
        }
        catch (JsonMappingException e) {
            ArrayList<Element> ret = new ArrayList<Element>();
            ArrayNode arrayNode = (ArrayNode)mapper.readTree(string);
            for (JsonNode jsonNode : arrayNode) {
                jsonNode = ElementMapper.analizeFullJson(jsonNode);
                ret.add(ElementMapper.unmarshal(Element.class, mapper.writeValueAsString((Object)jsonNode)));
            }
            return ret;
        }
    }

    static {
        AccessType[] accessTypes;
        logger = LoggerFactory.getLogger(ElementMapper.class);
        mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        knownTypes = new HashMap<String, Class<? extends Element>>();
        ArrayList<Package> packages = new ArrayList<Package>();
        Class<Type> tdClz = Type.class;
        ElementMapper.registerSubtype(tdClz);
        packages.add(tdClz.getPackage());
        for (AccessType accessType : accessTypes = AccessType.values()) {
            Class clz = accessType.getTypeClass();
            if (Type.class.isAssignableFrom(clz)) continue;
            Class dummyClz = accessType.getDummyImplementationClass();
            if (dummyClz != null) {
                ElementMapper.registerSubtypes(clz, dummyClz);
            } else {
                ElementMapper.registerSubtype(clz);
            }
            packages.add(clz.getPackage());
        }
        ElementMapper.registerPackages(packages);
        ServiceLoader<RegistrationProvider> regsitrationProviders = ServiceLoader.load(RegistrationProvider.class);
        for (RegistrationProvider registrationProvider : regsitrationProviders) {
            ElementMapper.registerPackages(registrationProvider.getPackagesToRegister());
        }
    }
}

