/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.model.reference.properties;

import java.util.Set;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.resourcemanagement.model.impl.properties.EnumStringPropertyImpl;
import org.gcube.resourcemanagement.model.reference.properties.GCubeProperty;
import org.gcube.resourcemanagement.model.reference.properties.utilities.PropertyValidator;
import org.gcube.resourcemanagement.model.reference.properties.utilities.ValidatedTypedProperty;
import org.gcube.resourcemanagement.model.reference.properties.utilities.Validation;

@JsonDeserialize(as=EnumStringPropertyImpl.class)
@TypeMetadata(name="EnumStringProperty", description="Enum String Property", version="1.0.0")
@Change(version="1.0.0", description="First Version")
public interface EnumStringProperty
extends GCubeProperty,
ValidatedTypedProperty<Set<String>, String> {
    public static final String NAME = "EnumStringProperty";

    @Override
    default public Validation validate() {
        return new SetStringValidator().validate(this);
    }

    public static class SetStringValidator
    implements PropertyValidator<EnumStringProperty> {
        @Override
        public Validation validate(EnumStringProperty property) {
            return ((Set)property.getSchema()).contains(property.getValue()) ? Validation.success("Accepted!") : Validation.fail((String)property.getValue() + " is not a valid value.");
        }
    }
}

