/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.request;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.handlers.application.RequestEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.gcube.smartgears.lifecycle.application.ApplicationState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="request-validation")
public class RequestValidator
extends RequestHandler {
    @XmlAttribute(required=false, name="oauth")
    @Deprecated
    boolean oauthCompatibility = false;
    private static Logger log = LoggerFactory.getLogger(RequestValidator.class);
    private ApplicationContext context;

    @Override
    public String getName() {
        return "request-validation";
    }

    @Override
    public void handleRequest(RequestEvent call) {
        log.trace("executing request validator ON REQUEST");
        this.context = (ApplicationContext)call.context();
        this.validateAgainstLifecycle(call);
        this.rejectUnauthorizedCalls(call);
        this.validateScopeCall();
    }

    private void validateAgainstLifecycle(RequestEvent call) {
        switch ((ApplicationState)this.context.lifecycle().state()) {
            case stopped: {
                RequestError.application_unavailable_error.fire();
                break;
            }
            case failed: {
                RequestError.application_failed_error.fire();
                break;
            }
        }
    }

    private void validateScopeCall() {
        String scope = ScopeProvider.instance.get();
        if (scope == null) {
            log.warn("rejecting unscoped call to {}", (Object)this.context.name());
            RequestError.invalid_request_error.fire("call is unscoped");
        }
        ScopeBean bean = new ScopeBean(scope);
        ContainerConfiguration conf = this.context.container().configuration();
        if (!(conf.allowedContexts().contains(scope) || conf.authorizeChildrenContext() && bean.is(ScopeBean.Type.VRE) && conf.allowedContexts().contains(bean.enclosingScope().toString()))) {
            log.warn("rejecting call to {} in invalid context {}, allowed context are {}", new Object[]{this.context.name(), scope, this.context.container().configuration().allowedContexts()});
            RequestError.invalid_request_error.fire(this.context.name() + " cannot be called in scope " + scope);
        }
    }

    private void rejectUnauthorizedCalls(RequestEvent call) {
        String token = SecurityTokenProvider.instance.get();
        String scope = ScopeProvider.instance.get();
        if (token == null && scope == null) {
            log.warn("rejecting call to {}, authorization required", (Object)this.context.name(), (Object)token);
            RequestError.request_not_authorized_error.fire(this.context.name() + ": authorization required");
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }
}

