/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types.impl.entities;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeName;
import org.gcube.informationsystem.base.reference.entities.EntityElement;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.types.TypeMapper;
import org.gcube.informationsystem.types.annotations.ResourceSchema;
import org.gcube.informationsystem.types.annotations.ResourceSchemaEntry;
import org.gcube.informationsystem.types.impl.entities.EntityTypeImpl;
import org.gcube.informationsystem.types.impl.properties.LinkedEntityImpl;
import org.gcube.informationsystem.types.reference.entities.ResourceType;
import org.gcube.informationsystem.types.reference.properties.LinkedEntity;

@JsonTypeName(value="ResourceType")
public class ResourceTypeImpl
extends EntityTypeImpl
implements ResourceType {
    private static final long serialVersionUID = -5964819173421808432L;
    protected List<LinkedEntity> facets;
    protected List<LinkedEntity> resources;

    protected ResourceTypeImpl() {
    }

    public ResourceTypeImpl(Class<? extends Resource> clz) {
        super((Class<? extends EntityElement>)clz);
        this.superClasses = this.retrieveSuperClasses(clz, Resource.class, "Entity");
        this.setResourceSchemaEntries(clz);
    }

    private void setResourceSchemaEntries(Class<? extends Resource> clz) {
        if (clz.isAnnotationPresent(ResourceSchema.class)) {
            LinkedEntityImpl resourceSchemaEntryDefinition;
            this.facets = new ArrayList<LinkedEntity>();
            this.resources = new ArrayList<LinkedEntity>();
            ResourceSchema[] resourceSchemaArray = (ResourceSchema[])clz.getAnnotationsByType(ResourceSchema.class);
            for (ResourceSchemaEntry resourceSchemaEntry : resourceSchemaArray[0].facets()) {
                resourceSchemaEntryDefinition = new LinkedEntityImpl();
                resourceSchemaEntryDefinition.setSource(TypeMapper.getType(clz));
                resourceSchemaEntryDefinition.setRelation(TypeMapper.getType(resourceSchemaEntry.relation()));
                resourceSchemaEntryDefinition.setTarget(TypeMapper.getType(resourceSchemaEntry.facet()));
                resourceSchemaEntryDefinition.setDescription(resourceSchemaEntry.description());
                resourceSchemaEntryDefinition.setMin(resourceSchemaEntry.min());
                resourceSchemaEntryDefinition.setMax(resourceSchemaEntry.max());
                this.facets.add(resourceSchemaEntryDefinition);
            }
            for (Annotation annotation : resourceSchemaArray[0].resources()) {
                resourceSchemaEntryDefinition = new LinkedEntityImpl();
                resourceSchemaEntryDefinition.setSource(TypeMapper.getType(annotation.source()));
                resourceSchemaEntryDefinition.setRelation(TypeMapper.getType(annotation.relation()));
                resourceSchemaEntryDefinition.setTarget(TypeMapper.getType(annotation.target()));
                resourceSchemaEntryDefinition.setDescription(annotation.description());
                resourceSchemaEntryDefinition.setMin(annotation.min());
                resourceSchemaEntryDefinition.setMax(annotation.max());
                this.resources.add(resourceSchemaEntryDefinition);
            }
        }
    }

    @Override
    public List<LinkedEntity> getFacets() {
        return this.facets;
    }

    @Override
    public List<LinkedEntity> getResources() {
        return this.resources;
    }
}

