/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.records.aggregation;

import java.util.Calendar;
import org.gcube.documentstore.persistence.PersistenceExecutor;
import org.gcube.documentstore.records.aggregation.AggregationConfiguration;
import org.gcube.documentstore.records.aggregation.AggregationScheduler;

public class BufferAggregationScheduler
extends AggregationScheduler {
    protected boolean firstOfBuffer = true;
    protected long firstBufferedTime;

    public BufferAggregationScheduler(PersistenceExecutor persistenceExecutor) {
        super(persistenceExecutor);
    }

    public BufferAggregationScheduler(PersistenceExecutor persistenceExecutor, AggregationConfiguration config) {
        super(persistenceExecutor, config);
    }

    @Override
    protected void schedulerSpecificClear() {
        this.firstOfBuffer = true;
    }

    @Override
    protected boolean isTimeToPersist(int maxRecordNumber, long oldRecordMaxTime) {
        long now = Calendar.getInstance().getTimeInMillis();
        if (this.firstOfBuffer) {
            this.firstOfBuffer = false;
            this.firstBufferedTime = now;
        }
        if (this.totalBufferedRecords >= maxRecordNumber) {
            logger.trace("Time persist from maxRecordNumber:" + maxRecordNumber + " max totalBufferedRecords:" + this.totalBufferedRecords);
            return true;
        }
        if (now - this.firstBufferedTime >= oldRecordMaxTime) {
            logger.trace("Time persist from oldRecordMaxTime:" + oldRecordMaxTime + " firstBufferedTime:" + this.firstBufferedTime);
            return true;
        }
        return false;
    }
}

