/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.managers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.gcube.smartgears.configuration.application.Exclude;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.application.DefaultApplicationContext;
import org.gcube.smartgears.handlers.application.ApplicationPipeline;
import org.gcube.smartgears.handlers.application.RequestEvent;
import org.gcube.smartgears.handlers.application.RequestHandler;
import org.gcube.smartgears.handlers.application.ResponseEvent;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.gcube.smartgears.handlers.application.request.RequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestManager
implements Filter {
    private static Logger log = LoggerFactory.getLogger(RequestManager.class);
    private final ApplicationContext context;
    private final String servlet;
    private final List<RequestHandler> handlers;

    public RequestManager(ApplicationContext context, String servletName, List<RequestHandler> handlers) {
        this.context = context;
        this.servlet = servletName;
        this.handlers = handlers;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httprequest = (HttpServletRequest)request;
        HttpServletResponse httpresponse = (HttpServletResponse)response;
        List<RequestHandler> filterHandlers = this.getPipelineWithExcluded(httprequest, this.handlers);
        if (filterHandlers.isEmpty()) {
            log.trace("filtered handlers are empty");
            chain.doFilter(request, response);
        } else {
            ApplicationPipeline<RequestHandler> pipeline = new ApplicationPipeline<RequestHandler>(filterHandlers);
            log.trace("filtered handler for this call are {}", filterHandlers);
            DefaultApplicationContext ctx = new DefaultApplicationContext(this.context);
            RequestEvent event = new RequestEvent(this.servlet, ctx, httprequest, httpresponse);
            try {
                pipeline.forward(event);
            }
            catch (Throwable t) {
                this.handleError(httprequest, httpresponse, t);
                return;
            }
            try {
                chain.doFilter(request, response);
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.handleError(httprequest, httpresponse, t);
            }
            ResponseEvent responseEvent = new ResponseEvent(this.servlet, ctx, httprequest, httpresponse);
            try {
                pipeline.reverse().forward(responseEvent);
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.handleError(httprequest, httpresponse, t);
                return;
            }
        }
    }

    private List<RequestHandler> getPipelineWithExcluded(HttpServletRequest request, List<RequestHandler> handlersToFilter) {
        String query = request.getQueryString();
        log.debug("servletPath is {} and pathInfo is {}", (Object)request.getServletPath(), (Object)request.getPathInfo());
        if ("wsdl".equals(query) || "wsdl=1".equals(query)) {
            return Collections.emptyList();
        }
        String path = request.getServletPath() == null ? "" : request.getServletPath();
        path = path + (request.getPathInfo() == null ? "" : request.getPathInfo());
        log.debug("check wich handler should be excluded {}", (Object)path);
        for (Exclude exclude : this.context.configuration().excludes()) {
            String excludePath = exclude.getPath();
            log.trace("exclude is {}", (Object)exclude);
            if (!"*".equals(excludePath) && (!excludePath.endsWith("*") || path == null || !path.startsWith(excludePath.substring(0, excludePath.length() - 2))) && !excludePath.equals(path) && (!path.endsWith("/") || !excludePath.equals(path.substring(0, path.length() - 1)))) continue;
            if (exclude.getHandlers().isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<RequestHandler> filteredHandlers = new ArrayList<RequestHandler>();
            for (RequestHandler rh : handlersToFilter) {
                if (exclude.getHandlers().contains(rh.getName())) continue;
                filteredHandlers.add(rh);
            }
            return filteredHandlers;
        }
        return handlersToFilter;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            for (RequestHandler handler : this.handlers) {
                handler.start(this.context);
            }
        }
        catch (Throwable t) {
            throw new ServletException(t);
        }
    }

    public void destroy() {
        for (RequestHandler handler : this.handlers) {
            try {
                handler.stop();
            }
            catch (Throwable t) {
                log.error("cannot terminate handler {} for application {} ", (Object)handler, (Object)this.context.name());
            }
        }
    }

    private void handleError(HttpServletRequest request, HttpServletResponse response, Throwable t) throws IOException {
        RequestError error;
        RequestError requestError = error = t instanceof RequestException ? ((RequestException)RequestException.class.cast(t)).error() : RequestError.application_error;
        if (error == RequestError.application_error) {
            response.sendError(error.code(), error.message());
        } else {
            if (error == RequestError.request_not_authorized_error) {
                response.setHeader("WWW-Authenticate", "Basic realm=\"Smartgears\"");
                log.info("setting WWW-Authenticate to response header");
            }
            response.getWriter().write("Error (" + error.code() + ") : " + error.message() + "\nStacktrace:\n");
            t.printStackTrace(response.getWriter());
            response.setStatus(error.code());
        }
    }
}

