/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.utils;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import rx.Observable;
import rx.Subscriber;

@InterfaceStability.Experimental
@InterfaceAudience.Private
public class Blocking {
    public static <T> T blockForSingle(Observable<? extends T> observable, long timeout, TimeUnit tu) {
        CountDownLatch latch = new CountDownLatch(1);
        TrackingSubscriber subscriber = new TrackingSubscriber(latch);
        observable.subscribe(subscriber);
        try {
            if (!latch.await(timeout, tu)) {
                throw new RuntimeException(new TimeoutException());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while waiting for subscription to complete.", e);
        }
        if (subscriber.returnException() != null) {
            if (subscriber.returnException() instanceof RuntimeException) {
                throw (RuntimeException)subscriber.returnException();
            }
            throw new RuntimeException(subscriber.returnException());
        }
        return subscriber.returnItem();
    }

    private static final class TrackingSubscriber<T>
    extends Subscriber<T> {
        private final CountDownLatch latch;
        private volatile T returnItem = null;
        private volatile Throwable returnException = null;

        public TrackingSubscriber(CountDownLatch latch) {
            this.latch = latch;
        }

        public void onCompleted() {
            this.latch.countDown();
        }

        public void onError(Throwable e) {
            this.returnException = e;
            this.latch.countDown();
        }

        public void onNext(T item) {
            this.returnItem = item;
        }

        public Throwable returnException() {
            return this.returnException;
        }

        public T returnItem() {
            return this.returnItem;
        }
    }
}

