/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.query.dsl.functions;

import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.java.query.dsl.Expression;
import java.util.ArrayList;
import java.util.List;

@InterfaceStability.Experimental
@InterfaceAudience.Public
public class Case {
    public static WhenClause caseSimple(Expression expected) {
        return new CaseBuilder(expected);
    }

    public static WhenClause caseSearch() {
        return new CaseBuilder(null);
    }

    private static final class CaseBuilder
    implements CaseClause,
    ThenClause {
        private int count = 0;
        private final List<Expression> whens;
        private final List<Expression> thens;
        private Expression elseResult = null;
        private final Expression caseExpression;

        private CaseBuilder(Expression caseExpression) {
            this.caseExpression = caseExpression;
            this.whens = new ArrayList<Expression>(1);
            this.thens = new ArrayList<Expression>(1);
        }

        @Override
        public ThenClause when(Expression conditionOrExpression) {
            this.whens.add(conditionOrExpression);
            this.thens.add(Expression.NULL());
            return this;
        }

        @Override
        public CaseClause then(Expression expression) {
            this.thens.set(this.count, expression);
            ++this.count;
            return this;
        }

        @Override
        public Expression elseReturn(Expression elseResult) {
            this.elseResult = elseResult;
            return this.end();
        }

        @Override
        public Expression end() {
            StringBuilder result = new StringBuilder("CASE ");
            if (this.caseExpression != null) {
                result.append(this.caseExpression.toString()).append(' ');
            }
            for (int i = 0; i < this.count; ++i) {
                result.append("WHEN ").append(this.whens.get(i)).append(" THEN ").append(this.thens.get(i)).append(' ');
            }
            result.delete(result.length() - 1, result.length());
            if (this.elseResult != null) {
                result.append(" ELSE ").append(this.elseResult.toString());
            }
            result.append(" END");
            return Expression.x(result.toString());
        }
    }

    public static interface ThenClause {
        public CaseClause then(Expression var1);
    }

    public static interface WhenClause {
        public ThenClause when(Expression var1);
    }

    public static interface CaseClause
    extends WhenClause {
        public Expression end();

        public Expression elseReturn(Expression var1);
    }
}

