/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.documentstore.persistence;

import java.util.Calendar;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.persistence.DefaultPersitenceExecutor;
import org.gcube.documentstore.persistence.ExecutorUtils;
import org.gcube.documentstore.persistence.FallbackPersistenceBackend;
import org.gcube.documentstore.persistence.PersistenceBackendConfiguration;
import org.gcube.documentstore.persistence.PersistenceBackendMonitor;
import org.gcube.documentstore.records.Record;
import org.gcube.documentstore.records.aggregation.AggregationScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistenceBackend {
    private static final Logger logger = LoggerFactory.getLogger(PersistenceBackend.class);
    protected FallbackPersistenceBackend fallbackPersistence;
    protected AggregationScheduler aggregationScheduler;
    protected PersistenceBackendMonitor persistenceBackendMonitor;
    public static final Integer MAX_FALLBACK = 3;
    protected static Integer countFallback;
    protected boolean timeoutFallback = false;
    protected long timerToFallback;
    public static final long MAX_TIME_TO_FALLBACK = 3600000L;
    protected boolean closed;

    protected PersistenceBackend() {
        if (!(this instanceof FallbackPersistenceBackend)) {
            this.persistenceBackendMonitor = new PersistenceBackendMonitor(this);
        }
        countFallback = 0;
        this.closed = true;
    }

    protected PersistenceBackend(FallbackPersistenceBackend fallback) {
        this();
        this.fallbackPersistence = fallback;
        this.aggregationScheduler = AggregationScheduler.newInstance(new DefaultPersitenceExecutor(this), "FALLBACK");
    }

    public FallbackPersistenceBackend getFallbackPersistence() {
        return this.fallbackPersistence;
    }

    protected void setFallback(FallbackPersistenceBackend fallback) {
        this.fallbackPersistence = fallback;
    }

    public AggregationScheduler getAggregationScheduler() {
        return this.aggregationScheduler;
    }

    protected void setAggregationScheduler(AggregationScheduler aggregationScheduler) {
        this.aggregationScheduler = aggregationScheduler;
    }

    protected abstract void prepareConnection(PersistenceBackendConfiguration var1) throws Exception;

    protected abstract void openConnection() throws Exception;

    protected abstract void closeConnection() throws Exception;

    public abstract void close() throws Exception;

    protected void closeAndClean() throws Exception {
    }

    protected abstract void reallyAccount(Record var1) throws Exception;

    protected void accountWithFallback(Record ... records) throws Exception {
        String persistenceName = this.getClass().getSimpleName();
        this.openConnection();
        for (Record record : records) {
            try {
                long now = Calendar.getInstance().getTimeInMillis();
                if (this.timeoutFallback) {
                    this.fallbackPersistence.reallyAccount(record);
                    logger.trace("accountWithFallback for timeout, now:{} and timerToFallback:{}", (Object)now, (Object)this.timerToFallback);
                    if (now - this.timerToFallback <= 3600000L) continue;
                    logger.debug("accountWithFallback MAX_TIME_TO_FALLBACK is conclused");
                    this.timeoutFallback = false;
                    this.timerToFallback = 0L;
                    continue;
                }
                this.reallyAccount(record);
                logger.trace("accountWithFallback {} accounted succesfully from {}.", (Object)record.toString(), (Object)persistenceName);
                this.timeoutFallback = false;
                this.timerToFallback = 0L;
            }
            catch (Exception e) {
                if (!(this instanceof FallbackPersistenceBackend) && e.getCause() != null && e.getCause() instanceof TimeoutException) {
                    logger.warn("accountWithFallback TimeoutException number:{} to  {}.", (Object)countFallback, (Object)MAX_FALLBACK);
                    Integer n = countFallback;
                    Integer n2 = countFallback = Integer.valueOf(countFallback + 1);
                    if (countFallback.equals(MAX_FALLBACK)) {
                        this.timeoutFallback = true;
                        this.timerToFallback = Calendar.getInstance().getTimeInMillis();
                        logger.trace("accountWithFallback Going to account {} in fallback for too many timeout", (Object)record);
                        countFallback = 0;
                        this.closeAndClean();
                    }
                } else {
                    logger.trace("accountWithFallback Fallback is same instance:{}" + this.getClass().getSimpleName());
                }
                try {
                    String fallabackPersistenceName = FallbackPersistenceBackend.class.getSimpleName();
                    logger.error("accountWithFallback {} was not accounted succesfully from {}. Trying to use {}.", new Object[]{record.toString(), persistenceName, fallabackPersistenceName, e});
                    this.fallbackPersistence.reallyAccount(record);
                    logger.trace("accountWithFallback {} accounted succesfully from {}", (Object)record.toString(), (Object)fallabackPersistenceName);
                }
                catch (Exception ex) {
                    logger.error("accountWithFallback {} was not accounted at all", (Object)record.toString(), (Object)e);
                }
            }
        }
        this.closeConnection();
    }

    protected void accountValidateAggregate(Record record, boolean validate, boolean aggregate) {
        try {
            logger.trace("Received {} to account : {}", (Object)record.getClass().getSimpleName(), (Object)record);
            if (validate) {
                record.validate();
            }
            if (aggregate) {
                try {
                    this.aggregationScheduler.aggregate(record, new DefaultPersitenceExecutor(this));
                }
                catch (Exception e) {
                    this.accountWithFallback(record);
                }
            } else {
                this.accountWithFallback(record);
            }
        }
        catch (InvalidValueException e) {
            logger.error("Error validating {}", (Object)record.getClass().getSimpleName(), (Object)e);
        }
        catch (Exception e) {
            logger.error("Error recording {}", (Object)record.getClass().getSimpleName(), (Object)e);
        }
    }

    public void account(final Record record) throws InvalidValueException {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                PersistenceBackend.this.accountValidateAggregate(record, true, true);
            }
        };
        ExecutorUtils.threadPool.execute(runnable);
    }

    public void flush(long timeout, TimeUnit timeUnit) throws Exception {
        this.aggregationScheduler.flush(new DefaultPersitenceExecutor(this));
    }

    public boolean isOpen() {
        return !this.closed;
    }

    protected void setOpen() {
        this.closed = false;
    }
}

