/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.impl.utils.discovery;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gcube.informationsystem.impl.utils.discovery.ERAction;
import org.gcube.informationsystem.impl.utils.discovery.ReflectionUtility;
import org.gcube.informationsystem.impl.utils.discovery.Tree;
import org.gcube.informationsystem.model.embedded.Embedded;
import org.gcube.informationsystem.model.entity.Entity;
import org.gcube.informationsystem.model.relation.Relation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ERDiscovery {
    private static Logger logger = LoggerFactory.getLogger(ERDiscovery.class);
    protected static Set<Package> packages = new HashSet<Package>();
    protected final Comparator<Class<Entity>> entityComparator = new Comparator<Class<Entity>>(){

        @Override
        public int compare(Class<Entity> o1, Class<Entity> o2) {
            return String.valueOf(o1).compareTo(String.valueOf(o2));
        }
    };
    protected final Comparator<Class<Relation>> relationComparator;
    protected final Comparator<Class<Embedded>> embeddedComparator;
    protected final Map<Class<Embedded>, Tree.Node<Class<Embedded>>> visitedEmbedded;
    protected final Map<Class<Entity>, Tree.Node<Class<Entity>>> visitedEntity = new TreeMap<Class<Entity>, Tree.Node<Class<Entity>>>(this.entityComparator);
    protected final Map<Class<Relation>, Tree.Node<Class<Relation>>> visitedRelation;
    protected final Tree<Class<Embedded>> embeddedTree;
    protected final Tree<Class<Entity>> entityTree = new Tree<Class<Entity>>(this.entityComparator, Entity.class);
    protected final Tree<Class<Relation>> relationTree;

    public static void addPackage(Package p) {
        packages.add(p);
    }

    public ERDiscovery() {
        this.visitedEntity.put(Entity.class, this.entityTree.getRootElement());
        this.relationComparator = new Comparator<Class<Relation>>(){

            @Override
            public int compare(Class<Relation> o1, Class<Relation> o2) {
                return String.valueOf(o1).compareTo(String.valueOf(o2));
            }
        };
        this.visitedRelation = new TreeMap<Class<Relation>, Tree.Node<Class<Relation>>>(this.relationComparator);
        this.relationTree = new Tree<Class<Relation>>(this.relationComparator, Relation.class);
        this.visitedRelation.put(Relation.class, this.relationTree.getRootElement());
        this.embeddedComparator = new Comparator<Class<Embedded>>(){

            @Override
            public int compare(Class<Embedded> o1, Class<Embedded> o2) {
                return String.valueOf(o1).compareTo(String.valueOf(o2));
            }
        };
        this.visitedEmbedded = new TreeMap<Class<Embedded>, Tree.Node<Class<Embedded>>>(this.embeddedComparator);
        this.embeddedTree = new Tree<Class<Embedded>>(this.embeddedComparator, Embedded.class);
        this.visitedEmbedded.put(Embedded.class, this.embeddedTree.getRootElement());
    }

    protected void addEntity(Class<? extends Entity> clz, Class<? extends Entity> parent) {
        Tree.Node<Class<Entity>> parentNode = this.visitedEntity.get(parent);
        logger.debug(" --------- Adding {} to {}", clz, parentNode);
        Tree.Node<Class<? extends Entity>> node = parentNode.addChild(clz);
        this.visitedEntity.put(clz, node);
    }

    protected void analizeEntity(Class<? extends Entity> clz) {
        Iterator i$;
        logger.trace(" --- Analizyng Entity {}", (Object)clz.getCanonicalName());
        if (this.visitedEntity.containsKey(clz)) {
            logger.trace(" --------- discarding {} because was already managed", clz);
            return;
        }
        Class<?>[] interfaces = clz.getInterfaces();
        ArrayList interfaceList = new ArrayList();
        for (Class<?> interfaceClass : interfaces) {
            if (!Entity.class.isAssignableFrom(interfaceClass)) {
                logger.trace(" --------- discarding {} because is not a {}", interfaceClass, (Object)Entity.class.getSimpleName());
                continue;
            }
            Class<?> e = interfaceClass;
            if (this.visitedEntity.containsKey(e)) {
                this.addEntity(clz, e);
                break;
            }
            interfaceList.add(e);
        }
        if (!this.visitedEntity.containsKey(clz) && (i$ = interfaceList.iterator()).hasNext()) {
            Class interfaceClass = (Class)i$.next();
            this.analizeEntity(interfaceClass);
            Class e = interfaceClass;
            this.addEntity(clz, e);
        }
        logger.trace("{}", (Object[])interfaces);
    }

    protected void addEmbedded(Class<? extends Embedded> clz, Class<? extends Embedded> parent) {
        Tree.Node<Class<Embedded>> parentNode = this.visitedEmbedded.get(parent);
        logger.debug(" --------- Adding {} to {}", clz, parentNode);
        Tree.Node<Class<? extends Embedded>> node = parentNode.addChild(clz);
        this.visitedEmbedded.put(clz, node);
    }

    protected void analizeEmbedded(Class<? extends Embedded> clz) {
        Iterator i$;
        logger.trace(" --- Analizyng Embedded {}", (Object)clz.getCanonicalName());
        if (this.visitedEmbedded.containsKey(clz)) {
            logger.trace(" --------- discarding {} because was already managed", clz);
            return;
        }
        Class<?>[] interfaces = clz.getInterfaces();
        ArrayList interfaceList = new ArrayList();
        for (Class<?> interfaceClass : interfaces) {
            if (!Embedded.class.isAssignableFrom(interfaceClass)) {
                logger.trace(" --------- discarding {} because is not a {}", interfaceClass, (Object)Embedded.class.getSimpleName());
                continue;
            }
            Class<?> e = interfaceClass;
            if (!this.visitedEmbedded.containsKey(e)) {
                this.analizeEmbedded(e);
                break;
            }
            interfaceList.add(e);
        }
        if (!this.visitedRelation.containsKey(clz) && (i$ = interfaceList.iterator()).hasNext()) {
            Class interfaceClass = (Class)i$.next();
            this.analizeEmbedded(interfaceClass);
            Class e = interfaceClass;
            this.addEmbedded(clz, e);
        }
        logger.trace("{}", (Object[])interfaces);
    }

    protected void addRelation(Class<? extends Relation> clz, Class<? extends Relation> parent) {
        Tree.Node<Class<Relation>> parentNode = this.visitedRelation.get(parent);
        logger.debug(" --------- Adding {} to {}", clz, parentNode);
        Tree.Node<Class<? extends Relation>> node = parentNode.addChild(clz);
        this.visitedRelation.put(clz, node);
    }

    protected void analizeRelation(Class<? extends Relation> clz) {
        Iterator i$;
        logger.trace(" --- Analizyng Relation {}", (Object)clz.getCanonicalName());
        if (this.visitedRelation.containsKey(clz)) {
            logger.trace(" --------- discarding {} because was already managed", clz);
            return;
        }
        Class<?>[] interfaces = clz.getInterfaces();
        ArrayList interfaceList = new ArrayList();
        for (Class<?> interfaceClass : interfaces) {
            if (!Relation.class.isAssignableFrom(interfaceClass)) {
                logger.trace(" --------- discarding {} because is not a {}", interfaceClass, (Object)Relation.class.getSimpleName());
                continue;
            }
            Class<?> r = interfaceClass;
            if (this.visitedRelation.containsKey(r)) {
                this.addRelation(clz, r);
                break;
            }
            interfaceList.add(r);
        }
        if (!this.visitedRelation.containsKey(clz) && (i$ = interfaceList.iterator()).hasNext()) {
            Class interfaceClass = (Class)i$.next();
            this.analizeRelation(interfaceClass);
            Class v = interfaceClass;
            this.addRelation(clz, v);
        }
        logger.trace("{}", (Object[])interfaces);
    }

    protected static <T> Tree.NodeVisitor<Class<T>> printNodeVisitor(Class<T> t) {
        return new Tree.NodeVisitor<Class<T>>(){

            @Override
            public boolean visit(Tree.Node<Class<T>> node) {
                StringBuilder sb = new StringBuilder();
                Tree.Node curr = node;
                do {
                    if (sb.length() > 0) {
                        sb.insert(0, " > ");
                    }
                    sb.insert(0, String.valueOf(curr.getValue()));
                } while ((curr = curr.getParent()) != null);
                logger.debug(sb.toString());
                return true;
            }
        };
    }

    protected <T> Tree.NodeVisitor<Class<T>> getNodeVisitor(Class<T> t, final ERAction erAction) {
        return new Tree.NodeVisitor<Class<T>>(){

            @Override
            public boolean visit(Tree.Node<Class<T>> node) {
                Class clz = node.getValue();
                try {
                    if (Embedded.class.isAssignableFrom(clz)) {
                        erAction.manageEmbeddedClass(clz);
                    } else if (Entity.class.isAssignableFrom(clz)) {
                        erAction.manageEntityClass(clz);
                    } else if (Relation.class.isAssignableFrom(clz)) {
                        erAction.manageRelationClass(clz);
                    }
                }
                catch (Exception e) {
                    logger.error("Error while visiting {} corresponding to {}", node, clz);
                }
                return true;
            }
        };
    }

    public void discoverERTypes() throws Exception {
        for (Package p : packages) {
            logger.trace("Analyzing {}", (Object)p);
            try {
                List<Class<?>> classes = ReflectionUtility.getClassesForPackage(p);
                for (Class<?> clz : classes) {
                    logger.trace("Analyzing {}", clz);
                    if (!clz.isInterface()) {
                        logger.trace("Discarding {} that is not an interface", clz);
                        continue;
                    }
                    if (Embedded.class.isAssignableFrom(clz)) {
                        this.analizeEmbedded(clz);
                    }
                    if (Entity.class.isAssignableFrom(clz)) {
                        this.analizeEntity(clz);
                    }
                    if (!Relation.class.isAssignableFrom(clz)) continue;
                    this.analizeRelation(clz);
                }
            }
            catch (ClassNotFoundException e) {
                logger.error("Error discovering classes inside package {}", (Object)p.getName(), (Object)e);
                throw e;
            }
        }
    }

    public void manageDiscoveredERTypes(ERAction erAction) throws Exception {
        Tree.NodeVisitor<Class<Embedded>> embeddedNodeVisitor = this.getNodeVisitor(Embedded.class, erAction);
        this.embeddedTree.visitNodes(embeddedNodeVisitor);
        Tree.NodeVisitor<Class<Entity>> vertexNodeVisitor = this.getNodeVisitor(Entity.class, erAction);
        this.entityTree.visitNodes(vertexNodeVisitor);
        Tree.NodeVisitor<Class<Relation>> edgeNodeVisitor = this.getNodeVisitor(Relation.class, erAction);
        this.relationTree.visitNodes(edgeNodeVisitor);
    }
}

