/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.resourceregistry.client.proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.ws.EndpointReference;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.AsyncProxyDelegate;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.informationsystem.impl.utils.Entities;
import org.gcube.informationsystem.model.entity.Facet;
import org.gcube.informationsystem.model.entity.Resource;
import org.gcube.informationsystem.resourceregistry.api.exceptions.InvalidQueryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.facet.FacetNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.entity.resource.ResourceNotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.schema.SchemaNotFoundException;
import org.gcube.informationsystem.resourceregistry.client.proxy.JaxRSEndpointReference;
import org.gcube.informationsystem.resourceregistry.client.proxy.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.proxy.ResourceRegistryQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceRegistryClientImpl
implements ResourceRegistryClient {
    private static final Logger logger = LoggerFactory.getLogger(ResourceRegistryClientImpl.class);
    private final AsyncProxyDelegate<EndpointReference> delegate;
    public static final String PATH_SEPARATOR = "/";

    public ResourceRegistryClientImpl(ProxyDelegate<EndpointReference> config) {
        this.delegate = new AsyncProxyDelegate(config);
    }

    @Override
    public Facet getFacet(UUID uuid) throws FacetNotFoundException, ResourceRegistryException {
        return this.getFacet(Facet.class, uuid);
    }

    @Override
    public <F extends Facet> F getFacet(Class<F> clazz, UUID uuid) throws FacetNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to get {} ({}) with UUID {}", new Object[]{"Facet", clazz.getSimpleName(), uuid});
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("facet");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("instance");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPInputs httpInputs = new HTTPInputs(stringWriter.toString(), HTTPMETHOD.GET, null);
            ResourceRegistryCall<F> call = new ResourceRegistryCall<F>(clazz, httpInputs);
            Facet f = (Facet)this.delegate.make(call);
            logger.info("Got {} ({}) with UUID {} is {}", new Object[]{"Facet", clazz.getSimpleName(), uuid, f});
            return (F)f;
        }
        catch (Exception e) {
            logger.error("Error getting {} with UUID {}", new Object[]{Facet.class.getSimpleName(), uuid, e});
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @Override
    public String getFacetSchema(String facetType) throws SchemaNotFoundException {
        try {
            logger.info("Going to get {} schema", (Object)facetType);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("facet");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("schema");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(facetType);
            HTTPInputs httpInputs = new HTTPInputs(stringWriter.toString(), HTTPMETHOD.GET, null);
            ResourceRegistryCall<String> call = new ResourceRegistryCall<String>(String.class, httpInputs);
            String schema = (String)this.delegate.make(call);
            logger.info("Got schema for {} is {}", (Object)facetType, (Object)schema);
            return schema;
        }
        catch (Exception e) {
            logger.error("Error getting {} Schema for {}", new Object[]{Facet.class.getSimpleName(), facetType, e});
            throw new SchemaNotFoundException((Throwable)e);
        }
    }

    @Override
    public Resource getResource(UUID uuid) throws ResourceNotFoundException, ResourceRegistryException {
        return this.getResource(Resource.class, uuid);
    }

    @Override
    public <R extends Resource> R getResource(Class<R> clazz, UUID uuid) throws ResourceNotFoundException, ResourceRegistryException {
        try {
            logger.info("Going to get {} ({}) with UUID {}", new Object[]{"Resource", clazz.getSimpleName(), uuid});
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("resource");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("instance");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(uuid.toString());
            HTTPInputs httpInputs = new HTTPInputs(stringWriter.toString(), HTTPMETHOD.GET, null);
            ResourceRegistryCall<R> call = new ResourceRegistryCall<R>(clazz, httpInputs);
            Resource r = (Resource)this.delegate.make(call);
            logger.info("Got {} ({}) with UUID {} is {}", new Object[]{"Resource", clazz.getSimpleName(), uuid, r});
            return (R)r;
        }
        catch (Exception e) {
            logger.error("Error getting {} with UUID {}", new Object[]{Resource.class.getSimpleName(), uuid, e});
            throw new ResourceRegistryException((Throwable)e);
        }
    }

    @Override
    public String getResourceSchema(String resourceType) throws SchemaNotFoundException {
        try {
            logger.info("Going to get {} schema", (Object)resourceType);
            StringWriter stringWriter = new StringWriter();
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("access");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("resource");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append("schema");
            stringWriter.append(PATH_SEPARATOR);
            stringWriter.append(resourceType);
            HTTPInputs httpInputs = new HTTPInputs(stringWriter.toString(), HTTPMETHOD.GET, null);
            ResourceRegistryCall<String> call = new ResourceRegistryCall<String>(String.class, httpInputs);
            String schema = (String)this.delegate.make(call);
            logger.info("Got schema for {} is {}", (Object)resourceType, (Object)schema);
            return schema;
        }
        catch (Exception e) {
            logger.error("Error getting {} Schema for {}", new Object[]{Resource.class.getSimpleName(), resourceType, e});
            throw new SchemaNotFoundException((Throwable)e);
        }
    }

    @Override
    public String query(String query, int limit, String fetchPlan) throws InvalidQueryException {
        ResourceRegistryQuery rrq = new ResourceRegistryQuery((ProxyDelegate<EndpointReference>)this.delegate);
        return rrq.query(query, limit, fetchPlan);
    }

    class ResourceRegistryCall<C>
    implements Call<EndpointReference, C> {
        protected final Class<C> clazz;
        protected final HTTPInputs httpInputs;

        public ResourceRegistryCall(Class<C> clazz, HTTPInputs httpInputs) {
            this.clazz = clazz;
            this.httpInputs = httpInputs;
        }

        protected String getURLStringFromEndpointReference(EndpointReference endpoint) throws IOException {
            JaxRSEndpointReference jaxRSEndpointReference = new JaxRSEndpointReference(endpoint);
            return jaxRSEndpointReference.toString();
        }

        protected HttpURLConnection getConnection(URL url, HTTPMETHOD method) throws Exception {
            url = new URL(url + "?" + this.httpInputs.getUrlParameters());
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            if (SecurityTokenProvider.instance.get() == null) {
                if (ScopeProvider.instance.get() == null) {
                    throw new RuntimeException("Null Token and Scope. Please set your token first.");
                }
                connection.setRequestProperty("gcube-scope", ScopeProvider.instance.get());
            } else {
                connection.setRequestProperty("gcube-token", SecurityTokenProvider.instance.get());
            }
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-type", "application/json");
            connection.setRequestProperty("User-Agent", ResourceRegistryClient.class.getSimpleName());
            connection.setRequestMethod(method.toString());
            return connection;
        }

        public C call(EndpointReference endpoint) throws Exception {
            String urlFromEndpointReference = this.getURLStringFromEndpointReference(endpoint);
            StringBuilder callUrl = new StringBuilder(urlFromEndpointReference);
            callUrl.append(this.httpInputs.getPath());
            URL url = new URL(callUrl.toString());
            HttpURLConnection connection = this.getConnection(url, this.httpInputs.method);
            logger.debug("Response code for {} is {} : {}", new Object[]{connection.getURL(), connection.getResponseCode(), connection.getResponseMessage()});
            if (connection.getResponseCode() != 200) {
                throw new Exception("Error Contacting Resource Registry Service");
            }
            StringBuilder result = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)connection.getContent()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    result.append(line);
                }
            }
            String res = result.toString();
            logger.trace("Server returned content : {}", (Object)res);
            if (String.class.isAssignableFrom(this.clazz)) {
                return (C)res;
            }
            return (C)Entities.unmarshal(this.clazz, (String)res);
        }
    }

    class HTTPInputs {
        public static final String PARAM_STARTER = "?";
        public static final String PARAM_EQUALS = "=";
        public static final String PARAM_SEPARATOR = "&";
        public static final String UTF8 = "UTF-8";
        protected final String path;
        protected final HTTPMETHOD method;
        protected final String urlParameters;

        protected String getParametersDataString(List<Map.Entry<String, String>> parameters) throws UnsupportedEncodingException {
            if (parameters == null) {
                return null;
            }
            StringBuilder result = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, String> entry : parameters) {
                if (first) {
                    first = false;
                } else {
                    result.append(PARAM_SEPARATOR);
                }
                result.append(URLEncoder.encode(entry.getKey(), UTF8));
                result.append(PARAM_EQUALS);
                result.append(URLEncoder.encode(entry.getValue(), UTF8));
            }
            return result.toString();
        }

        public HTTPInputs(String path, HTTPMETHOD method, List<Map.Entry<String, String>> parameters) throws UnsupportedEncodingException {
            this.path = path;
            this.method = method;
            this.urlParameters = this.getParametersDataString(parameters);
        }

        public String getPath() {
            return this.path;
        }

        public HTTPMETHOD getMethod() {
            return this.method;
        }

        public String getUrlParameters() {
            return this.urlParameters;
        }
    }

    protected static enum HTTPMETHOD {
        GET,
        POST,
        PUT,
        DELETE;


        public String toString() {
            return this.name();
        }
    }

    public final class RREntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        public RREntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V old = this.value;
            this.value = value;
            return old;
        }
    }
}

