/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.handlers.application.lifecycle;

import java.net.URI;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import javax.servlet.ServletRegistration;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.lifecycle.application.ApplicationState;

public class ProfileBuilder {
    public static List<String> servletExcludes = Arrays.asList("default", "jsp");
    private ApplicationContext context;

    public ProfileBuilder(ApplicationContext context) {
        this.context = context;
    }

    public static String getBaseAddress(ApplicationContext context) {
        String baseAddress;
        ApplicationConfiguration configuration = context.configuration();
        ContainerConfiguration container = context.container().configuration();
        if (configuration.proxied()) {
            String protocol = container.proxyAddress().secure() ? "https://" : "http://";
            int port = container.proxyAddress().port();
            baseAddress = String.format("%s%s:%d%s", protocol, container.proxyAddress().hostname(), port, context.application().getContextPath());
        } else {
            String protocol = configuration.secure() ? "https://" : "http://";
            int port = configuration.secure() ? container.securePort().intValue() : container.port();
            baseAddress = String.format("%s%s:%d%s", protocol, container.hostname(), port, context.application().getContextPath());
        }
        return baseAddress;
    }

    public static String getAddressFromBaseAddress(String baseAddress, String mapping) {
        return baseAddress + (mapping.endsWith("*") ? mapping.substring(0, mapping.length() - 2) : mapping);
    }

    public void fill(GCoreEndpoint endpoint) {
        ApplicationConfiguration configuration = this.context.configuration();
        endpoint.profile().description(configuration.description()).serviceName(configuration.name()).serviceClass(configuration.serviceClass()).version(configuration.version()).serviceId(configuration.name() + configuration.serviceClass() + configuration.version()).ghnId(this.context.container().profile(HostingNode.class).id());
        endpoint.profile().newDeploymentData().activationTime(Calendar.getInstance()).status(((ApplicationState)this.context.lifecycle().state()).remoteForm());
        endpoint.profile().endpoints().clear();
        String baseAddress = ProfileBuilder.getBaseAddress(this.context);
        for (ServletRegistration servlet : this.context.application().getServletRegistrations().values()) {
            if (servletExcludes.contains(servlet.getName())) continue;
            for (String mapping : servlet.getMappings()) {
                String address = baseAddress + (mapping.endsWith("*") ? mapping.substring(0, mapping.length() - 2) : mapping);
                ((GCoreEndpoint.Profile.Endpoint)endpoint.profile().endpoints().add()).nameAndAddress(servlet.getName(), URI.create(address));
            }
        }
    }
}

